/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.BeanChatMessage;
import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.BeanMessage;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class ActFixConversationsIfNeeded
implements DBService.Action {
    private static final String TAG = "ActFixConversationsIfNeeded";

    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        List results;
        this.createMessageTablesIfNeeded(helper, daoSet);
        Dao conversationsDao = daoSet.create(null, BeanConversation.class);
        try {
            results = conversationsDao.queryForAll();
        }
        catch (SQLException t) {
            return;
        }
        DeleteBuilder builder = conversationsDao.deleteBuilder();
        builder.where().isNull("name");
        builder.delete();
        for (BeanConversation bean : results) {
            if (bean.name == null) continue;
            Identifiable target = IDFactory.makeId((String)bean.name);
            if (target == null) {
                this.dropIllegalConversation(helper, daoSet, bean);
                continue;
            }
            this.recoverMissingMessageTable(helper, daoSet, target);
        }
        Log.i((String)TAG, (Object)"ActFixConversationsIfNeeded Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverMissingMessageTable(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet, Identifiable target) {
        GenericRawResults rawResults = null;
        DatabaseTableConfig<BeanChatMessage> tableConfig = BeanChatMessage.chatMessageTableConfig(target);
        try {
            Dao dao = daoSet.create(tableConfig, null);
            rawResults = dao.queryRaw("SELECT * FROM " + tableConfig.getTableName() + " LIMIT 1", new String[0]);
        }
        catch (SQLException t) {
            try {
                TableUtils.createTableIfNotExists((ConnectionSource)helper.getConnectionSource(), tableConfig);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            DaoManager.clearDaoCache();
        }
        finally {
            if (rawResults != null) {
                try {
                    rawResults.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void dropIllegalConversation(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet, BeanConversation bean) {
        try {
            Dao dao = daoSet.create(null, BeanConversation.class);
            dao.deleteById((Object)bean.name);
        }
        catch (SQLException dao) {
            // empty catch block
        }
        try {
            DatabaseTableConfig tbConfig = new DatabaseTableConfig();
            String tableName = "conversation_" + bean.name;
            tbConfig.setTableName(tableName);
            tbConfig.setDataClass(BeanMessage.class);
            TableUtils.dropTable((ConnectionSource)helper.getConnectionSource(), (DatabaseTableConfig)tbConfig, (boolean)true);
            DaoManager.clearDaoCache();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageTablesIfNeeded(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) {
        DatabaseTableConfig<BeanChatMessage> tableConfig = BeanChatMessage.chatMessageTableConfig(0);
        GenericRawResults rawResults = null;
        try {
            Dao dao = daoSet.create(tableConfig, null);
            rawResults = dao.queryRaw("SELECT * FROM " + tableConfig.getTableName() + " LIMIT 1", new String[0]);
        }
        catch (SQLException e) {
            for (int i = 0; i < 64; ++i) {
                tableConfig = BeanChatMessage.chatMessageTableConfig(i);
                try {
                    TableUtils.createTableIfNotExists((ConnectionSource)helper.getConnectionSource(), tableConfig);
                }
                catch (SQLException e1) {
                    Log.e((String)TAG, (Object)Trace.method((String)"createMessageTablesIfNeeded").msg((Object)("create table " + i + " error")));
                }
                DaoManager.clearDaoCache();
            }
        }
        finally {
            if (rawResults != null) {
                try {
                    rawResults.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return "Hummer.FixConversationsIfNeeded";
    }
}

