/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import androidx.annotation.NonNull;
import com.hummer.im.HMR;
import com.hummer.im._internals.BeanChatMessage;
import com.hummer.im._internals.ChatUtils;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class ActFetchMessages
implements DBService.Action {
    List<Message> results;
    private final FetchingClauses clauses;
    private final Chat chat;

    ActFetchMessages(@NonNull Chat chat, @NonNull FetchingClauses clauses) {
        this.chat = chat;
        this.clauses = clauses;
    }

    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        DatabaseTableConfig<BeanChatMessage> tableConfig = BeanChatMessage.chatMessageTableConfig(this.chat.getTarget());
        Dao dao = daoSet.create(tableConfig, null);
        QueryBuilder queryBuilder = dao.queryBuilder();
        Where where = queryBuilder.where();
        where.eq("deleted", (Object)false);
        where.and();
        String condition = this.chat.getTarget().equals(HMR.getMe()) ? String.format("(%s = '%s' AND %s = '%s')", "sender", IDFactory.makeString((Identifiable)this.chat.getTarget()), "receiver", IDFactory.makeString((Identifiable)this.chat.getTarget())) : (this.chat.getTarget() instanceof User ? String.format("((%s = '%s' AND %s = '%s') OR (%s = '%s' AND %s = '%s'))", "sender", IDFactory.makeString((Identifiable)this.chat.getTarget()), "receiver", IDFactory.makeString((Identifiable)HMR.getMe()), "sender", IDFactory.makeString((Identifiable)HMR.getMe()), "receiver", IDFactory.makeString((Identifiable)this.chat.getTarget())) : String.format("(%s = '%s' OR %s = '%s')", "sender", IDFactory.makeString((Identifiable)this.chat.getTarget()), "receiver", IDFactory.makeString((Identifiable)this.chat.getTarget())));
        where.raw(condition, new ArgumentHolder[0]);
        Long ts = this.clauses.getBeforeTimestamp();
        String uuid = this.clauses.getUuid();
        if (this.clauses.getBeforeMessage() != null) {
            if (ts == null) {
                ts = this.clauses.getBeforeMessage().getTimestamp();
            }
            if (uuid == null) {
                uuid = this.clauses.getBeforeMessage().getUuid();
            }
        }
        if (ts != null) {
            where.and();
            if (uuid != null) {
                where.lt("msg_id", (Object)ChatUtils.getMsgId(ts, uuid));
                where.and().ne("id", (Object)uuid);
            } else {
                where.le("timestamp", (Object)ts);
            }
        }
        if (this.clauses.getLimit() != null) {
            queryBuilder.limit(Long.valueOf(this.clauses.getLimit().intValue()));
        }
        queryBuilder.orderBy("msg_id", false);
        List dbMessages = queryBuilder.query();
        this.results = BeanChatMessage.toMessages(dbMessages);
        Collections.reverse(this.results);
    }

    public String toString() {
        return "Hummer.FetchMessages | chat: " + this.chat + ", clauses: " + this.clauses;
    }
}

