/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.ActUpdateChatLatestMsg;
import com.hummer.im._internals.BeanChatMessage;
import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.BeanMessage;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im.db.DBActions;
import com.hummer.im.db.DBService;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;
import java.util.List;

public class ActChatUpgrade
implements DBService.Action {
    private static final String TAG = "ActChatUpgrade";
    private HMRCompletion completion;

    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        Log.i((String)TAG, (Object)Trace.method((String)"process").msg((Object)"Upgrade conversation table"));
        int oldVersion = ((DBService)HMR.getService(DBService.class)).getOldVersion();
        int newVersion = ((DBService)HMR.getService(DBService.class)).getNewVersion();
        if (oldVersion == newVersion) {
            CompletionUtils.dispatchSuccess((HMRCompletion)this.completion);
            return;
        }
        Dao dao = daoSet.create(null, BeanConversation.class);
        if (oldVersion < newVersion) {
            if (oldVersion < 2) {
                this.upgradeToVersion2(daoSet, dao);
            } else if (oldVersion < 3) {
                this.upgradeToVersion3(daoSet, dao);
            } else if (oldVersion < 4) {
                this.upgradeToVersion4(daoSet, dao);
            } else if (oldVersion < 5) {
                this.upgradeToVersion5(daoSet, dao);
            }
        }
    }

    private void upgradeToVersion2(final DBService.DaoSet daoSet, final Dao<BeanConversation, ?> dao) throws SQLException {
        String addLatestMsg = "ALTER TABLE `" + dao.getTableName() + "` ADD COLUMN " + "latest_msg" + " TEXT;";
        dao.executeRaw(addLatestMsg, new String[0]);
        String addUnreadNum = "ALTER TABLE `" + dao.getTableName() + "` ADD COLUMN " + "unread_num" + " INTEGER;";
        dao.executeRaw(addUnreadNum, new String[0]);
        String addTimestamp = "ALTER TABLE `" + dao.getTableName() + "` ADD COLUMN " + "timestamp" + " REAL;";
        dao.executeRaw(addTimestamp, new String[0]);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().queryAll(BeanConversation.class, (DBActions.QueryAcceptor)new DBActions.QueryAcceptor<BeanConversation>(){

            public void onQueryResults(List<BeanConversation> indexes) {
                for (BeanConversation index : indexes) {
                    ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new ActUpdateChatLatestMsg(BeanConversation.toConversation(index)));
                }
                try {
                    ActChatUpgrade.this.upgradeToVersion3(daoSet, dao);
                }
                catch (SQLException e) {
                    Error error = new Error(1003, "\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38: " + e.getMessage());
                    Log.e((String)ActChatUpgrade.TAG, (Object)Trace.method((String)"execute").msg((Object)error));
                    CompletionUtils.dispatchFailure((HMRCompletion)ActChatUpgrade.this.completion, (Error)error);
                }
            }
        }));
    }

    private void upgradeToVersion3(DBService.DaoSet daoSet, Dao<BeanConversation, ?> dao) throws SQLException {
        String addPriorityField = "ALTER TABLE " + dao.getTableName() + " ADD COLUMN " + "priority" + " INTEGER DEFAULT 0 ";
        dao.executeRawNoArgs(addPriorityField);
        String addTagsField = "ALTER TABLE " + dao.getTableName() + " ADD COLUMN " + "tags" + " TEXT DEFAULT '[]' ";
        dao.executeRawNoArgs(addTagsField);
        this.mergeTable(daoSet, dao);
    }

    private void upgradeToVersion4(DBService.DaoSet daoSet, Dao<BeanConversation, ?> dao) throws SQLException {
        String addNewContentField = "ALTER TABLE %s ADD COLUMN new_content TEXT DEFAULT ''";
        boolean flag = true;
        for (int i = 0; i < 64; ++i) {
            DatabaseTableConfig<BeanChatMessage> tableConfig = BeanChatMessage.chatMessageTableConfig(i);
            Dao chatDao = daoSet.create(tableConfig, BeanChatMessage.class);
            if (flag) {
                try {
                    chatDao.executeRawNoArgs(String.format(addNewContentField, tableConfig.getTableName()));
                }
                catch (SQLException e) {
                    Log.e((String)TAG, (Object)Trace.method((String)"upgradeToVersion4").msg((Object)"column `new_content` is exist, ignore"));
                    flag = false;
                }
            }
            chatDao.updateRaw("update " + tableConfig.getTableName() + " set " + "push_content" + " = ''", new String[0]);
        }
        this.upgradeToVersion5(daoSet, dao);
    }

    private void upgradeToVersion5(DBService.DaoSet daoSet, Dao<BeanConversation, ?> dao) throws SQLException {
        String addIsLastMessageField = "ALTER TABLE %s ADD COLUMN is_last_message INTEGER DEFAULT 1";
        String addStoreStrategy = "ALTER TABLE %s ADD COLUMN store_strategy TEXT DEFAULT ''";
        boolean flag = true;
        for (int i = 0; i < 64; ++i) {
            DatabaseTableConfig<BeanChatMessage> tableConfig = BeanChatMessage.chatMessageTableConfig(i);
            Dao chatDao = daoSet.create(tableConfig, BeanChatMessage.class);
            if (!flag) continue;
            try {
                chatDao.executeRawNoArgs(String.format(addIsLastMessageField, tableConfig.getTableName()));
                chatDao.executeRawNoArgs(String.format(addStoreStrategy, tableConfig.getTableName()));
                continue;
            }
            catch (SQLException e) {
                Log.e((String)TAG, (Object)Trace.method((String)"upgradeToVersion5").msg((Object)"column `is_last_message` and 'store_strategy' is exist, ignore"));
                flag = false;
            }
        }
        CompletionUtils.dispatchSuccess((HMRCompletion)this.completion);
    }

    private void mergeTable(final DBService.DaoSet daoSet, final Dao<BeanConversation, ?> dao) {
        DBActions actions = new DBActions();
        for (int i = 0; i < 64; ++i) {
            actions.custom((DBService.Action)new DBActions().createTableIfNeeded(BeanChatMessage.chatMessageTableConfig(i)));
        }
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)actions);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().queryAll(BeanConversation.class, (DBActions.QueryAcceptor)new DBActions.QueryAcceptor<BeanConversation>(){

            public void onQueryResults(List<BeanConversation> indexes) {
                for (BeanConversation index : indexes) {
                    Identifiable target = IDFactory.makeId((String)index.name);
                    final DatabaseTableConfig<BeanChatMessage> newMsgTableConfig = BeanChatMessage.chatMessageTableConfig(target);
                    DatabaseTableConfig<BeanMessage> oldMsgTableConfig = BeanMessage.conversationConfig(target);
                    ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().queryAll(oldMsgTableConfig, (DBActions.QueryAcceptor)new DBActions.QueryAcceptor<BeanMessage>(){

                        public void onQueryResults(List<BeanMessage> result) {
                            List<Message> messages = BeanMessage.toMessages(result);
                            for (Message msg : messages) {
                                ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().create((Object)BeanChatMessage.fromMessage(msg), newMsgTableConfig));
                            }
                        }
                    }));
                }
                try {
                    ActChatUpgrade.this.upgradeToVersion4(daoSet, dao);
                }
                catch (SQLException e) {
                    Error error = new Error(1003, "\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38: " + e.getMessage());
                    Log.e((String)ActChatUpgrade.TAG, (Object)Trace.method((String)"execute").msg((Object)error));
                    CompletionUtils.dispatchFailure((HMRCompletion)ActChatUpgrade.this.completion, (Error)error);
                }
            }
        }));
    }

    ActChatUpgrade(HMRCompletion completion) {
        this.completion = completion;
    }
}

