/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.BeanChatMessage;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;
import java.util.Locale;

public final class ActAddOrUpdateMessage
implements DBService.Action {
    private final Message message;
    private final Chat chat;
    private final Callback completion;
    private static final String UPDATE_SQL = "update %s set %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ? where %s = ?";

    ActAddOrUpdateMessage(Chat chat, Message message, Callback callback) {
        this.chat = chat;
        this.message = message;
        this.completion = callback;
    }

    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        boolean notExisted;
        BeanChatMessage dbMessage = BeanChatMessage.fromMessage(this.message);
        DatabaseTableConfig<BeanChatMessage> tableConfig = BeanChatMessage.chatMessageTableConfig(this.chat.getTarget());
        Dao dao = daoSet.create(tableConfig, null);
        boolean bl = notExisted = !dao.idExists((Object)dbMessage.id);
        if (notExisted) {
            dao.create((Object)dbMessage);
            this.completion.afterSaved(true);
        } else {
            String stmt = String.format(Locale.US, UPDATE_SQL, tableConfig.getTableName(), "timestamp", "state", "kv_extra", "app_extra", "push_content", "content", "new_content", "msg_id", "id");
            daoSet.create(tableConfig, null).updateRaw(stmt, new String[]{dbMessage.timestamp + "", dbMessage.state, dbMessage.kvExtra, dbMessage.appExtra, dbMessage.pushContent, dbMessage.content, dbMessage.newContent, dbMessage.msgId, dbMessage.id});
            this.completion.afterSaved(false);
        }
    }

    public String toString() {
        return "Hummer.ActAddOrUpdateMessage | chat: " + this.chat + ", message: " + this.message;
    }

    public static interface Callback {
        public void afterSaved(boolean var1);
    }
}

