package com.hummer.im.model.kick;

public enum KickOffEnum {

    /**
     * 被踢
     */
    KICK_OFF(0),

    /**
     * 多端互踢
     */
    MULTIJOIN_KICK_OFF(1),

    /**
     * 未定义
     */
    UNDEFINED(-1);

    private int type;

    KickOffEnum(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }

    /**
     * 根据type获取枚举类型
     *
     * @param type 踢人类型
     * @return KickOffEnum
     */
    public static KickOffEnum getByType(int type) {
        for (KickOffEnum kickOffEnum : KickOffEnum.values()) {
            if (kickOffEnum.type == type) {
                return kickOffEnum;
            }
        }
        return UNDEFINED;
    }
}
