package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;


public class RPCKickOffUser extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public RPCKickOffUser(long uid, int roomId, long secs, String reason, RichCompletion completion) {
        this.uid        = uid;
        this.roomId     = roomId;
        this.secs       = secs;
        this.reason     = reason;
        this.completion = completion;
    }

    @Override
    public String getFunctionName() {
        return "KickOffUser";
    }

    @Override
    public String getChatroomServiceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_KickOffReq req = new ChatRoomProto.PCS_KickOffReq();
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.roomid = Uint32.toUInt(roomId);
        req.admin  = Uint64.toUInt(HMR.getMe().getId());
        req.uid    = Uint64.toUInt(this.uid);
        req.secs   = Uint64.toUInt(this.secs);
        req.reason = this.reason;
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private final RichCompletion completion;
    private final long uid;
    private final int  roomId;
    private final long secs;
    private final String reason;
}
