package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.id.User;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.completion.CompletionUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 获取禁言的用户列表
 */
public class RPCFetchMutedMemberList extends ChatRoomRPC<ChatRoomProto.PCS_DisableTextUserListResp> {

    private final int roomid;
    private final RichCompletionArg<Set<User>> completion;


    public RPCFetchMutedMemberList(int roomid, RichCompletionArg<Set<User>> completion) {
        this.roomid = roomid;
        this.completion = completion;
    }

    @Override
    public String getChatroomServiceName() {
        return "chatroom_tempservice";
    }

    @Override
    public String getFunctionName() {
        return "GetChatRoomDisableTextUser";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_DisableTextUserListReq req
                = new ChatRoomProto.PCS_DisableTextUserListReq();
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.roomid = Uint32.toUInt(roomid);

        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_DisableTextUserListResp resp) {
        Set<User> muteMembers = new HashSet<>();
        for (Uint64 uid : resp.uids) {
            User user = new User(uid.longValue());
            muteMembers.add(user);
        }

        CompletionUtils.dispatchSuccess(completion, muteMembers);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }
}
