package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.completion.CompletionUtils;

/**
 * 获取聊天室信息
 */
public class RPCFetchChatRoomInfo extends ChatRoomRPC<ChatRoomProto.PCS_ChatRoomInfoRes> {
    public RPCFetchChatRoomInfo(int roomId, RichCompletionArg<ChatRoomInfo> completion) {
        this.roomId = roomId;
        this.mCompletion = completion;
    }

    @Override
    public String getFunctionName() {
        return "GetChatRoomInfo";
    }

    @Override
    public String getChatroomServiceName() {
        return "chatroom_sinfo";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_ChatRoomInfoReq req = new ChatRoomProto.PCS_ChatRoomInfoReq();
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.roomId = Uint32.toUInt(roomId);
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_ChatRoomInfoRes res) {
        String title =
                res.props.containsKey(ChatRoomInfo.BasicInfoType.Name.name()) ?
                        res.props.get(ChatRoomInfo.BasicInfoType.Name.name()) : "";
        String description = res.props
                .containsKey(ChatRoomInfo.BasicInfoType.Description.name()) ?
                res.props.get(ChatRoomInfo.BasicInfoType.Description.name()) : "";
        String bulletin =
                res.props.containsKey(ChatRoomInfo.BasicInfoType.Bulletin.name()) ?
                        res.props.get(ChatRoomInfo.BasicInfoType.Bulletin.name()) :
                        "";
        String appExtra = res.props.containsKey(ChatRoomInfo.BasicInfoType.AppExtra.name()) ?
                res.props.get(ChatRoomInfo.BasicInfoType.AppExtra.name()) : "";

        ChatRoomInfo chatRoomInfo = new ChatRoomInfo(title, description, bulletin, appExtra);

        Log.i("RPCFetchChatRoomInfo", Trace.once().method("dispatchSuccess")
                .info("result", chatRoomInfo.toString()));
        CompletionUtils.dispatchSuccess(mCompletion, chatRoomInfo);
    }

    @Override
    public void handleError(@NonNull Error err) {
        Log.i("RPCFetchChatRoomInfo", Trace.once().method("dispatchFailure")
                .info("result", err.toString()));
        CompletionUtils.dispatchFailure(mCompletion, err);
    }

    private final RichCompletionArg<ChatRoomInfo> mCompletion;
    private final int roomId;
}
