package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;

/**
 * 聊天室禁言
 */
public class RPCDisableUserText extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {

    private final long opUid;
    private final long uid;
    private final int roomid;
    private final long secs;
    private final boolean disable;
    private final String reason;
    private final RichCompletion completion;

    public RPCDisableUserText(long opUid,
                              long uid,
                              int roomid,
                              long secs,
                              boolean disable,
                              String reason,
                              RichCompletion completion) {
        this.opUid = opUid;
        this.uid = uid;
        this.roomid = roomid;
        this.secs = secs;
        this.disable = disable;
        this.reason = reason;
        this.completion = completion;
    }

    @Override
    public String getChatroomServiceName() {
        return "chatroom_auther";
    }

    @Override
    public String getFunctionName() {
        return "DisableUserText";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_DisableUserTextReq req = new ChatRoomProto.PCS_DisableUserTextReq();
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.opUid = Uint64.toUInt(this.opUid);
        req.uid = Uint64.toUInt(this.uid);
        req.roomid = Uint32.toUInt(roomid);
        req.secs   = Uint64.toUInt(this.secs);
        req.disable = this.disable;
        req.reason = this.reason;
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }
}
