package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;

import java.util.Map;


public class RPCChatRoomTextChat extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCChatRoomTextChat";

    public RPCChatRoomTextChat(long roomId,
                               String chat,
                               Map<String, String> chatProps,
                               Map<String, String> extProps,
                               RichCompletion completion) {
        this.roomId = Uint32.toUInt(roomId);
        this.chat = chat;
        this.chatProps = chatProps;
        this.extProps = extProps;
        this.mCompletion = completion;
    }

    @Override
    public String getFunctionName() {
        return "SendTextChat";
    }

    @Override
    public String getChatroomServiceName() {
        return "chatroom_textchat";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_TextChat2Req req = new ChatRoomProto.PCS_TextChat2Req();
        req.uid = Uint64.toUInt(HMR.getMe().getId());
        req.chat = chat;
        req.roomId = roomId;
        req.appKey = Uint32.toUInt(HMRContext.appId);
        req.chatprops = this.chatProps;
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res)
            throws Throwable {
        CompletionUtils.dispatchSuccess(mCompletion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(mCompletion, err);
    }

    private final Uint32 roomId;
    private final String chat;
    private final Map<String, String> chatProps;
    private final Map<String, String> extProps;
    private final RichCompletion mCompletion;
}