package com.hummer.im.chatroom._internals.proto;

/**
 * Created by chenkaicai on 2019/4/28.
 */

import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Pack;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im._internals.yyp.packet.MarshalContainer;
import com.hummer.im._internals.yyp.packet.UnmarshalContainer;
import com.hummer.im._internals.yyp.packet.Unpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChatRoomProto {
    public static final int SESSION_SVID = 2;
    public static final int SDB_SVID = 7;
    public static final int UINFO_SVID = 3;
    public static final int CHAT_ROOM_SVID = 205;

    public enum ChatRoomOpEnum {
        NULOP,
        ADD,
        REMOVE,
        CHANGE,
    }

    public static class AdminRoleTypeEnum {
        private String code;

        public AdminRoleTypeEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 更新聊天室的基本信息查询
     */
    public static class PCS_ChatRoomInfoRes implements Marshallable {
        public Uint32 appkey = new Uint32(0);
        public Uint32 roomId = new Uint32(0);
        public Map<String, String> props = new HashMap<>();
        public Uint32 rescode = new Uint32(0);

        @Override
        public int getUri() {
            return (13307 << 8 | CHAT_ROOM_SVID);
        }

        @Override
        public void marshall(Pack pack) {
        }

        @Override
        public void unmarshall(Unpack up) {
            appkey = up.popUint32();
            roomId = up.popUint32();
            rescode = up.popUint32();
            UnmarshalContainer.unmarshalMapStringString(up, props);
        }
    }

    /**
     * 聊天室的基本信息查询
     */
    public static class PCS_ChatRoomInfoReq implements Marshallable {
        public static final int uri = (13306 << 8 | CHAT_ROOM_SVID);

        public Uint32 appkey;
        public Uint32 roomId;

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey).push(roomId);
        }

        @Override
        public void unmarshall(Unpack up) {
        }
    }

    /**
     * 更新聊天室的基本信息
     */
    public static class PCS_UpdateChatRoomInfoReq extends BaseChatRoomParams {
        public static final int uri = (107 << 8 | CHAT_ROOM_SVID);

        public Map<String, String> props = new HashMap<>();

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            super.marshall(pack);
            MarshalContainer.marshalMapStringString(pack, props);
        }
    }

    /**
     * 拉取在线用户列表的返回对像
     */
    public static class PCS_PullOnlineUserListRes implements Marshallable {
        public Uint32 appkey = new Uint32(0);
        public Uint32 topsid = new Uint32(0);
        public Uint32 pos = new Uint32(0);
        public List<Uint64> users = new ArrayList<>();
        public Uint32 rescode = new Uint32(0);

        @Override
        public int getUri() {
            return (13303 << 8 | CHAT_ROOM_SVID);
        }

        @Override
        public void marshall(Pack pack) {
        }

        @Override
        public void unmarshall(Unpack up) {
            appkey = up.popUint32();
            topsid = up.popUint32();
            pos = up.popUint32();
            //TODO 复合对像转换同
            //users=up.popUint64Set();
            UnmarshalContainer.unmarshalColUint64(up, users);
            rescode = up.popUint32();
        }
    }

    /**
     * 普通用户列表对像请求
     */
    public static class PCS_PullOnlineUserListReq implements Marshallable {
        public static final int uri = (13302 << 8 | CHAT_ROOM_SVID);

        public Uint32 appkey = new Uint32(0);
        public Uint32 roomid = new Uint32(0);
        public Uint32 num = new Uint32(0);
        public Uint32 pos = new Uint32(0);

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey).push(roomid).push(num).push(pos);
        }

        @Override
        public void unmarshall(Unpack up) {
        }
    }

    /**
     * 管理员结果集返回
     */
    public static class PCS_PullAdminUserRes implements Marshallable {
        public Uint32 appkey = new Uint32(0);
        public Uint32 roomId = new Uint32(0);
        //TODO key的类型是否等同与上面的topsid
        public HashMap<String, ArrayList<Uint64>> admins = new HashMap<>();
        public Uint32 rescode = new Uint32(0);

        @Override
        public int getUri() {
            return (13305 << 8 | CHAT_ROOM_SVID);
        }

        @Override
        public void marshall(Pack pack) {
        }

        @Override
        public void unmarshall(Unpack up) {
            appkey = up.popUint32();
            roomId = up.popUint32();
            //TODO 复合对像转换同
            UnmarshalContainer.unmarshalMapStringListUint64(up, admins);
            rescode = up.popUint32();
        }
    }

    /**
     * 拉取管理员列表
     */
    public static class PCS_PullAdminUserReq implements Marshallable {
        public static final int uri = (13304 << 8 | CHAT_ROOM_SVID);

        public Uint32 appkey;
        public Uint32 roomId;
        public String role;

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey).push(roomId).push(role);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    /**
     * 拉取管理员列表
     */
    public static class PCS_ChatRoomManagerReq implements Marshallable {
        public static final int uri = (13322 << 8 | CHAT_ROOM_SVID);

        public Uint32 appkey;
        public Uint32 roomId;
        public String role;

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey).push(roomId).push(role);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    /**
     * 管理员结果集返回
     */
    public static class PCS_ChatRoomManagerRes implements Marshallable {
        public Uint32 appkey = new Uint32(0);
        public Uint32 roomId = new Uint32(0);
        //TODO key的类型是否等同与上面的topsid
        public HashMap<String, ArrayList<Uint64>> admins = new HashMap<>();
        public Uint32 rescode = new Uint32(0);

        @Override
        public int getUri() {
            return (13323 << 8 | CHAT_ROOM_SVID);
        }

        @Override
        public void marshall(Pack pack) {
        }

        @Override
        public void unmarshall(Unpack up) {
            appkey = up.popUint32();
            roomId = up.popUint32();
            //TODO 复合对像转换同
            UnmarshalContainer.unmarshalMapStringListUint64(up, admins);
            rescode = up.popUint32();
        }
    }

    /**
     * 更新管理员角色
     */
    public static class PCS_UpdateChatRoomRolerReq extends BaseChatRoomParams {
        public static final int uri = (113 << 8 | CHAT_ROOM_SVID);

        public Uint64 admin;
        public Uint32 op;
        public String roler;

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey).push(admin).push(uid).push(roomid).push(op).push(roler);
        }
    }

    /**
     * 踢人
     */
    public static class PCS_KickOffReq extends BaseChatRoomParams {
        public static final int uri = (111 << 8 | CHAT_ROOM_SVID);

        public Uint64 admin;
        public Uint64 secs;
        public String reason;

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey).push(admin).push(uid).push(roomid).push(secs).push(reason);
        }
    }

    /**
     * 离开聊天室
     */
    public static class PCS_LeaveChatRoomReq extends BaseChatRoomParams {
        public static final int uri = (103 << 8 | CHAT_ROOM_SVID);

        @Override
        public int getUri() {
            return uri;
        }
    }

    /**
     * 进行聊天室
     */
    public static class PCS_JoinChatRoomReq extends BaseChatRoomParams {
        public static final int uri = (101 << 8 | CHAT_ROOM_SVID);
        // 当加入频道时，可以在joinProps中加入该key， value '0'表示不互踢，'1'表示互踢
        public static final String mMultiJoinByInstanceId = "join_props_multijoin_by_instanceId";

        public Uint32 joinbyPassword = new Uint32(1); //频道密码
        public Uint32 joinMode = new Uint32(2); //0：正常进频道， 1：断线重连
        public Map<String, String> joinProps = new HashMap<>(); //key改为string // add "_prop"

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            super.marshall(pack);
            MarshalContainer.marshalMapStringString(pack, joinProps);
        }
    }

    public static abstract class BaseChatRoomParams implements Marshallable {
        public Uint32 appkey;
        public Uint64 uid;
        public Uint32 roomid;

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey);
            pack.push(uid);
            pack.push(roomid);
        }

        @Override
        public void unmarshall(Unpack up) {
        }
    }

    /**
     * 聊天室删除
     */
    public static class PCS_DismissChatRoomReq extends BaseChatRoomParams {
        public static final int uri = (109 << 8 | CHAT_ROOM_SVID);

        @Override
        public int getUri() {
            return uri;
        }
    }

    /**
     * 创建聊天室
     */
    public static class PCS_CreateChatRoomReq implements Marshallable {
        public static final int uri = (105 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Map<String, String> props = new HashMap<String, String>();

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appKey);
            pack.push(uid);
            MarshalContainer.marshalMapStringString(pack, props);
        }

        @Override
        public void unmarshall(Unpack up) {
        }
    }

    public static class PCS_TextChat2Req implements Marshallable {

        public static final int uri = (3020 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Uint32 roomId = new Uint32(0);
        public String chat = "";
        public Map<String, String> chatprops = new HashMap<>();
        public Map<String, String> extProps = new HashMap<>();

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appKey);
            pack.push(uid);
            pack.push(roomId);
            pack.push(chat);
            MarshalContainer.marshalMapStringString(pack, chatprops);
            MarshalContainer.marshalMapStringString(pack, extProps);
        }

        @Override
        public void unmarshall(Unpack up) {
        }
    }

    public static class PCS_CommonOperatorAuth2Res implements Marshallable {
        public int uri = (100 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint32 innerUri = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Uint32 roomId = new Uint32(0);
        public Uint32 res = new Uint32(0);
        public Map<String, String> props = new HashMap<String, String>();
        public String msg = null;

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            innerUri = unpack.popUint32();
            uid = unpack.popUint64();
            roomId = unpack.popUint32();
            res = unpack.popUint32();
            UnmarshalContainer.unmarshalMapStringString(unpack, props);
            if (unpack.size() > 0) {
                msg = unpack.popString();
            }
        }
    }

    public static class PCS_SendBroadcastReq implements Marshallable {
        public int uri = (115 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Uint32 roomId = new Uint32(0);
        public String content = "";

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appKey);
            pack.push(uid);
            pack.push(roomId);
            pack.push(content);
        }

        @Override
        public void unmarshall(Unpack unpack) {
        }
    }

    public static class PCS_SendUnicastReq implements Marshallable {
        public int uri = (117 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Uint32 roomId = new Uint32(0);
        public String content = "";
        public Uint64 receiver = new Uint64(0);

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appKey);
            pack.push(uid);
            pack.push(roomId);
            pack.push(content);
            pack.push(receiver);
        }

        @Override
        public void unmarshall(Unpack unpack) {
        }
    }

    /**
     * 用户禁言
     */
    public static class PCS_DisableUserTextReq implements Marshallable {

        private static final int URI = (119 << 8 | CHAT_ROOM_SVID);

        public Uint32 appkey = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Uint32 roomid = new Uint32(0);
        public Uint64 opUid = new Uint64(0);
        public Uint64 secs = new Uint64(0);
        public boolean disable = false;
        public String reason = "";

        @Override
        public int getUri() {
            return URI;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey)
                    .push(opUid)
                    .push(uid)
                    .push(roomid)
                    .push(secs)
                    .push(disable)
                    .push(reason);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    /**
     * 获取禁言用户列表请求
     */
    public static class PCS_DisableTextUserListReq implements Marshallable {
        private static final int URI = 13375 << 8 | CHAT_ROOM_SVID;

        public Uint32 appkey = new Uint32(0);
        public Uint32 roomid = new Uint32(0);

        @Override
        public int getUri() {
            return URI;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appkey).push(roomid);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    /**
     * 获取禁言用户列表响应
     */
    public static class PCS_DisableTextUserListResp implements Marshallable {
        private static final int URI = 13376 << 8 | CHAT_ROOM_SVID;

        public Uint32 appkey = new Uint32(0);
        public Uint32 roomid = new Uint32(0);
        public Uint32 rescode = new Uint32(0);
        public Set<Uint64> uids = new HashSet<>();

        @Override
        public int getUri() {
            return URI;
        }
        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack up) {
            appkey = up.popUint32();
            roomid = up.popUint32();
            rescode = up.popUint32();
            UnmarshalContainer.unmarshalColUint64(up, uids);
        }

        @Override
        public String toString() {
            return "PCS_DisableTextUserListResp: {uid.size=" + uids.size() + "}";
        }
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /*广播协议*/

    public static class PCS_KickOffUserBc implements Marshallable {
        public static final int uri = (1058 << 8 | CHAT_ROOM_SVID);

        public Uint32 appkey = new Uint32(0);
        public Uint32 topsid = new Uint32(0);
        public Uint64 admin = new Uint64(0);
        public List<Uint64> tuids = new ArrayList<Uint64>();
        public Uint32 mSecs = new Uint32(0);
        public String mReason = "";
        /** 0：表示被踢；1：表示多端互踢 */
        public Uint32 type = new Uint32(0);

        @Override

        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {
        }

        @Override
        public void unmarshall(Unpack unpack) {
            appkey = unpack.popUint32();
            topsid = unpack.popUint32();
            admin = unpack.popUint64();
            UnmarshalContainer.unmarshalColUint64(unpack, tuids);
            mSecs = unpack.popUint32();
            mReason = unpack.popString();
            type = unpack.popUint32();
        }

    }

    /**
     * 在线人数变化通知
     */
    public static class PCS_PushChatRoomUserCountBC extends BaseChatRoomParams {
        public static final int uri = (13364 << 8 | CHAT_ROOM_SVID);
        public Uint32 appkey = new Uint32(0);
        public Uint32 topsid = new Uint32(0);
        public Uint32 totalCount = new Uint32(0);

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void unmarshall(Unpack unpack) {
            appkey = unpack.popUint32();
            topsid = unpack.popUint32();
            totalCount = unpack.popUint32();
        }

    }

    /**
     * 聊天室用户在线状态变更通知
     */
    public static class PCS_CreateChatRoomBc extends BaseChatRoomParams {
        public static final int uri = (1054 << 8 | CHAT_ROOM_SVID);
        public Uint32 appKey = new Uint32(0);
        public Map<String, String> props = new HashMap<>();

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            uid = unpack.popUint64();
            roomid = unpack.popUint32();
            props = unpack.popMapByKeyStringAndValueString();
        }
    }

    /**
     * 聊天室用户在线状态变更通知
     */
    public static class PCS_DismissChatRoomBc extends BaseChatRoomParams {
        public static final int uri = (1055 << 8 | CHAT_ROOM_SVID);
        public Uint32 appKey = new Uint32(0);

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            uid = unpack.popUint64();
            roomid = unpack.popUint32();
        }
    }

    /**
     * 聊天室信息更新广播
     */
    public static class PCS_UpdateChatRoomInfoBc extends BaseChatRoomParams {
        public static final int uri = (1056 << 8 | CHAT_ROOM_SVID);
        public Uint32 appKey = new Uint32(0);
        public Map<String, String> props = new HashMap<>();

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            uid = unpack.popUint64();
            roomid = unpack.popUint32();
            UnmarshalContainer.unmarshalMapStringString(unpack, props);
        }
    }

    /**
     * 角色更新的广播通知
     */
    public static class PCS_UpdateChatRoomRolerBc extends BaseChatRoomParams {
        public static final int uri = (1057 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint64 admin = new Uint64(0);
        public Uint32 op = new Uint32(0);
        public String roler = "";

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            admin = unpack.popUint64();
            uid = unpack.popUint64();
            roomid = unpack.popUint32();
            op = unpack.popUint32();
            roler = unpack.popString();
        }
    }

    //聊天室用户在线状态变更通知
    public static class PCS_ChatRoomUserBc implements Marshallable {
        public static final int uri = (13374 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint32 roomId = new Uint32(0);
        public ArrayList<Uint64> joinUsers = new ArrayList<>();
        public ArrayList<Uint64> leaveUsers = new ArrayList<>();

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            roomId = unpack.popUint32();
            UnmarshalContainer.unmarshalColUint64(unpack, joinUsers);
            UnmarshalContainer.unmarshalColUint64(unpack, leaveUsers);
        }
    }

    public static class PCS_TextChatBc implements Marshallable {
        public static final int uri = (3022 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Uint32 roomId = new Uint32(0);
        public String chat = "";
        public Map<String, String> chatProps = new HashMap<>();
        public Map<String, String> extProps = new HashMap<>();

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            uid = unpack.popUint64();
            roomId = unpack.popUint32();
            chat = unpack.popString();
            UnmarshalContainer.unmarshalMapStringString(unpack, chatProps);
            UnmarshalContainer.unmarshalMapStringString(unpack, extProps);
        }
    }

    public static class PCS_SendBroadcastBc implements Marshallable {
        public static final int uri = (1060 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Uint32 roomId = new Uint32(0);
        public String content = "";

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            uid = unpack.popUint64();
            roomId = unpack.popUint32();
            content = unpack.popString();
        }
    }

    public static class PCS_SendUnicastUc implements Marshallable {
        public static final int uri = (2054 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public Uint32 roomId = new Uint32(0);
        public String content = "";
        public Uint64 receiver = new Uint64(0);

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            uid = unpack.popUint64();
            roomId = unpack.popUint32();
            content = unpack.popString();
            receiver = unpack.popUint64();
        }
    }

    public static class PCS_DisableUserTextBc implements Marshallable {

        public static final int URI = (1062 << 8 | CHAT_ROOM_SVID);

        public Uint32 appkey = new Uint32(0);
        public Uint64 opUid = new Uint64(0);
        public Set<Uint64> tuids = new HashSet<>();
        public Uint32 roomid = new Uint32(0);
        public Uint64 secs = new Uint64(0);
        public boolean disable = false;
        public String reason = "";

        @Override
        public int getUri() {
            return URI;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack unpack) {
            appkey = unpack.popUint32();
            opUid = unpack.popUint64();
            UnmarshalContainer.unmarshalColUint64(unpack, tuids);
            roomid = unpack.popUint32();
            secs = unpack.popUint64();
            disable = unpack.popBoolean();
            reason = unpack.popString();
        }
    }
}
