/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.chatsvc.ChatServiceImpl;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Receiver;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom.Challenges;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom.ChatRoomService;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.RPCChangeChatRoomInfo;
import com.hummer.im.chatroom._internals.rpc.RPCChangeChatRoomRole;
import com.hummer.im.chatroom._internals.rpc.RPCChatRoomTextChat;
import com.hummer.im.chatroom._internals.rpc.RPCCreateChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCDisableUserText;
import com.hummer.im.chatroom._internals.rpc.RPCDismissChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCFetchAdminList;
import com.hummer.im.chatroom._internals.rpc.RPCFetchChatRoomInfo;
import com.hummer.im.chatroom._internals.rpc.RPCFetchMemberList;
import com.hummer.im.chatroom._internals.rpc.RPCFetchMutedMemberList;
import com.hummer.im.chatroom._internals.rpc.RPCJoinChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCKickOffUser;
import com.hummer.im.chatroom._internals.rpc.RPCLeaveChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCPullAllAdminUser;
import com.hummer.im.chatroom._internals.rpc.RPCSendBroadcast;
import com.hummer.im.chatroom._internals.rpc.RPCSendUnicast;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.contents.Text;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.ChatRoom;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.model.kick.KickOff;
import com.hummer.im.model.kick.KickOffEnum;
import com.hummer.im.service.Channel;
import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.utils.UserGroupType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ChatRoomServiceImpl
implements ServiceProvider.Service,
ChatRoomService,
Channel.NotificationHandler,
Channel.StateChangedListener {
    private static final long kRejoinConditionGap = 60000L;
    private static final long kReferenceValue = 946656000L;
    private long mInitialTimeInterval = 0L;
    private static final int kickTimeSec = 300;
    private static final String TAG = "ChatRoomService";
    private static final long onlineBCGrpType = 0x80000002L;
    private static final long authBCGrpType = 0x80000001L;
    private static final long textChatBCGrpType = 0x80000000L;
    private static final int MUTED_TIME_SEC = 259200;
    private final Set<ChatRoomService.MemberListener> memberListeners = new HashSet<ChatRoomService.MemberListener>();
    private final Set<ChatRoomService.ChatRoomListener> listeners = new HashSet<ChatRoomService.ChatRoomListener>();
    private final Set<ChatRoom> chatRooms = new HashSet<ChatRoom>();

    public Class[] staticDependencies() {
        return new Class[]{Channel.class};
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class, Channel.class};
    }

    public Class[] plantingDynamicDependencies() {
        return null;
    }

    public void initService() {
        this.registerChatServiceExtensions();
    }

    public void openService(@NonNull RichCompletion richCompletion) {
        ((Channel)HMR.getService(Channel.class)).addStateListener((Channel.StateChangedListener)this);
        ((Channel)HMR.getService(Channel.class)).addNotificationHandler((Channel.NotificationHandler)this);
        CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
    }

    public void closeService() {
        if (this.chatRooms.size() > 0) {
            for (ChatRoom chatRoom : this.chatRooms) {
                Log.i((String)TAG, (Object)String.format(Locale.US, "leave chatRoom after closeService, roomId:%d", chatRoom.getId()));
                this.leaveChatRoom(chatRoom, null);
            }
            this.chatRooms.clear();
        }
        this.resetInitialTimeInterval();
        ((Channel)HMR.getService(Channel.class)).removeNotificationHandler((Channel.NotificationHandler)this);
        ((Channel)HMR.getService(Channel.class)).removeStateListener((Channel.StateChangedListener)this);
    }

    private void registerChatServiceExtensions() {
        ChatServiceImpl.registerSendingExtension((ChatServiceImpl.SendingExtension)new ChatServiceImpl.SendingExtension(){

            public Channel.RPC makeSendingRPC(final Message message, RichCompletion richCompletion) {
                if (!(message.getSender() instanceof User) || !(message.getReceiver() instanceof ChatRoom)) {
                    return null;
                }
                ChatRoom chatRoom = (ChatRoom)message.getReceiver();
                if (message.getContent() instanceof Text) {
                    return new RPCChatRoomTextChat(chatRoom.getId(), ((Text)message.getContent()).getText(), (Map<String, String>)new HashMap<String, String>(){
                        {
                            this.put("uuid", message.getUuid());
                            if (message.getAppExtra() != null) {
                                this.put("extra", message.getAppExtra());
                            }
                        }
                    }, null, richCompletion);
                }
                if (message.getContent() instanceof ChatRoomService.Signal) {
                    ChatRoomService.Signal signal = (ChatRoomService.Signal)message.getContent();
                    if (signal.user == null) {
                        return new RPCSendBroadcast(chatRoom.getId(), signal.content, richCompletion);
                    }
                    return new RPCSendUnicast(chatRoom.getId(), signal.content, signal.user.getId(), richCompletion);
                }
                return null;
            }
        });
        ChatServiceImpl.registerParserExtension((ChatServiceImpl.ParserExtension)new ChatServiceImpl.ParserExtension(){

            public String toString() {
                return "ChatRoom";
            }

            public Message parseMessage(String string, String string2, byte[] byArray) {
                if ("chatroom_textchat".equals(string) && "TextChatBc".equals(string2)) {
                    Receiver receiver = new Receiver(byArray);
                    receiver.parseHeader();
                    if (receiver.getUri().intValue() != 773837) {
                        return null;
                    }
                    ChatRoomProto.PCS_TextChatBc pCS_TextChatBc = new ChatRoomProto.PCS_TextChatBc();
                    receiver.unmarshallWrap((Marshallable)pCS_TextChatBc);
                    ChatRoom chatRoom = new ChatRoom(pCS_TextChatBc.roomId.longValue());
                    Text text = new Text(pCS_TextChatBc.chat);
                    Message message = new Message((Identifiable)chatRoom, (Content)text);
                    message.setState((Message.State)new Archived());
                    message.setSender((Identifiable)new User(pCS_TextChatBc.uid.longValue()));
                    String string3 = pCS_TextChatBc.chatProps.get("uuid");
                    if (TextUtils.isEmpty((CharSequence)string3)) {
                        message.setUuid(UUID.randomUUID().toString());
                    } else {
                        message.setUuid(pCS_TextChatBc.chatProps.get("uuid"));
                    }
                    message.setAppExtra(pCS_TextChatBc.chatProps.get("extra"));
                    message.setTimestamp(System.currentTimeMillis());
                    return message;
                }
                if ("chatroom_auther".equals(string) && "SendUnicastUc".equals(string2)) {
                    Receiver receiver = new Receiver(byArray);
                    receiver.parseHeader();
                    if (receiver.getUri().intValue() != 526029) {
                        return null;
                    }
                    ChatRoomProto.PCS_SendUnicastUc pCS_SendUnicastUc = new ChatRoomProto.PCS_SendUnicastUc();
                    receiver.unmarshallWrap((Marshallable)pCS_SendUnicastUc);
                    Message message = new Message((Identifiable)new ChatRoom(pCS_SendUnicastUc.roomId.longValue()), (Content)ChatRoomService.Signal.unicast(new User(pCS_SendUnicastUc.receiver.longValue()), pCS_SendUnicastUc.content));
                    message.setSender((Identifiable)new User(pCS_SendUnicastUc.uid.longValue()));
                    message.setUuid(UUID.randomUUID().toString());
                    message.setTimestamp(System.currentTimeMillis());
                    return message;
                }
                if ("chatroom_auther".equals(string) && "SendBroadcastBc".equals(string2)) {
                    Receiver receiver = new Receiver(byArray);
                    receiver.parseHeader();
                    if (receiver.getUri().intValue() != 271565) {
                        return null;
                    }
                    ChatRoomProto.PCS_SendBroadcastBc pCS_SendBroadcastBc = new ChatRoomProto.PCS_SendBroadcastBc();
                    receiver.unmarshallWrap((Marshallable)pCS_SendBroadcastBc);
                    Message message = new Message((Identifiable)new ChatRoom(pCS_SendBroadcastBc.roomId.longValue()), (Content)ChatRoomService.Signal.broadcast(pCS_SendBroadcastBc.content));
                    message.setSender((Identifiable)new User(pCS_SendBroadcastBc.uid.longValue()));
                    message.setUuid(UUID.randomUUID().toString());
                    message.setTimestamp(System.currentTimeMillis());
                    return message;
                }
                return null;
            }

            public Message parseMessage(Im.Msg msg, Source source) {
                return null;
            }
        });
    }

    @Override
    public void switchRegion(String string) {
        HMRContext.chatRoomRegion = string.toLowerCase(Locale.US);
    }

    @Override
    public void createChatRoom(@NonNull ChatRoomInfo chatRoomInfo, @NonNull HMR.CompletionArg<ChatRoom> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "CHatRoomService::createChatRoom");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"createChatRoom subject:%s", (Object[])new Object[]{chatRoomInfo.getName()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCCreateChatRoom(chatRoomInfo, (RichCompletionArg<ChatRoom>)richCompletionArg));
    }

    @Override
    public void dismissChatRoom(@NonNull ChatRoom chatRoom, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::dismissChatRoom");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"deleteChatRoom chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCDismissChatRoom(Long.valueOf(chatRoom.getId()).intValue(), richCompletion));
    }

    @Override
    public void join(final @NonNull ChatRoom chatRoom, final @NonNull Map<String, String> map, final @NonNull Challenges.JoiningCompletion joiningCompletion) {
        Log.i((String)TAG, (Object)Trace.once((String)"join chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        if (HMR.getState() != HMR.State.Opened) {
            DispatchQueue.main.async("ChatRoomService::joinFailCallback", new Runnable(){

                @Override
                public void run() {
                    joiningCompletion.onFailure(new Error(1011, "User not login"));
                }
            });
            return;
        }
        if (HMR.getMe().isAnonymous()) {
            HMRContext.work.async("ChatRoomService::subscribe", new Runnable(){

                @Override
                public void run() {
                    ChatRoomServiceImpl.this._subscribeChatRoomBC(chatRoom, new RichCompletion("ChatRoomService::subscribe").onSuccess(new OnSuccess(){

                        public void onSuccess() {
                            ChatRoomServiceImpl.this.addChatRoom(chatRoom);
                            DispatchQueue.main.async("ChatRoomService::subscribeSuccessCallback", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onSucceed();
                                }
                            });
                        }
                    }).onFailure(new OnFailure(){

                        public void onFailure(final Error error) {
                            DispatchQueue.main.async("ChatRoomService::subscribeFailureCallback", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onFailure(error);
                                }
                            });
                        }
                    }));
                }
            });
        } else {
            HMRContext.work.async("ChatRoomService::join", new Runnable(){

                @Override
                public void run() {
                    ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCJoinChatRoom((int)chatRoom.getId(), map, new Challenges.JoiningCompletion(){

                        @Override
                        public void onReceiveChallenge(final Challenges.Password password) {
                            DispatchQueue.main.async("ChatRoomService::onReceiveChallengePassword", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onReceiveChallenge(password);
                                }
                            });
                        }

                        @Override
                        public void onReceiveChallenge(final Challenges.AppChallenge appChallenge) {
                            DispatchQueue.main.async("ChatRoomService::onReceiveChallengeAppChallenge", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onReceiveChallenge(appChallenge);
                                }
                            });
                        }

                        @Override
                        public void onSucceed() {
                            ChatRoomServiceImpl.this.addChatRoom(chatRoom);
                            ChatRoomServiceImpl.this._subscribeChatRoomBC(chatRoom, new RichCompletion("ChatRoomService::joinSuccess").onSuccess(new OnSuccess(){

                                public void onSuccess() {
                                    DispatchQueue.main.async("ChatRoomService::joinSuccess", new Runnable(){

                                        @Override
                                        public void run() {
                                            joiningCompletion.onSucceed();
                                        }
                                    });
                                }
                            }).onFailure(new OnFailure(){

                                public void onFailure(Error error) {
                                    this.onFailure(error);
                                }
                            }));
                        }

                        @Override
                        public void onFailure(final @NonNull Error error) {
                            DispatchQueue.main.async("ChatRoomService::joinFailure", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onFailure(error);
                                }
                            });
                        }
                    }));
                }
            });
        }
    }

    @Override
    public void leave(final @NonNull ChatRoom chatRoom, @Nullable HMR.Completion completion) {
        Log.i((String)TAG, (Object)Trace.once((String)"leave chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        final RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::leave");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"leave chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        HMRContext.work.async("ChatRoomService::leave", new Runnable(){

            @Override
            public void run() {
                ChatRoomServiceImpl.this.leaveChatRoom(chatRoom, richCompletion);
                ChatRoomServiceImpl.this.removeChatRoom(chatRoom);
            }
        });
    }

    @Override
    public void kick(final @NonNull ChatRoom chatRoom, final @NonNull User user, final @Nullable Map<ChatRoomService.EKickInfo, String> map, @NonNull HMR.Completion completion) {
        final RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::kick");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"kick id:%s fellow:%s", (Object[])new Object[]{chatRoom.getId(), user.getId()}));
        HMRContext.work.async("ChatRoomService::kick", new Runnable(){

            @Override
            public void run() {
                long l = 300L;
                String string = "";
                if (map != null && map.containsKey((Object)ChatRoomService.EKickInfo.Time)) {
                    l = Long.parseLong((String)map.get((Object)ChatRoomService.EKickInfo.Time));
                }
                if (map != null && map.containsKey((Object)ChatRoomService.EKickInfo.Reason)) {
                    string = (String)map.get((Object)ChatRoomService.EKickInfo.Reason);
                }
                ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCKickOffUser(user.getId(), (int)chatRoom.getId(), l, string, richCompletion));
            }
        });
    }

    @Override
    public void addRole(@NonNull ChatRoom chatRoom, @NonNull User user, @NonNull String string, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::addRole");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"addRole id:%s fellow:%s role:%s", (Object[])new Object[]{chatRoom.getId(), user.getId(), string}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomRole(chatRoom.getId(), user.getId(), new ChatRoomProto.AdminRoleTypeEnum(string), ChatRoomProto.ChatRoomOpEnum.ADD, richCompletion));
    }

    @Override
    public void removeRole(@NonNull ChatRoom chatRoom, @NonNull User user, @NonNull String string, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::removeRole");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"removeRole id:%s fellow:%s role:%s", (Object[])new Object[]{chatRoom.getId(), user.getId(), string}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomRole(chatRoom.getId(), user.getId(), new ChatRoomProto.AdminRoleTypeEnum(string), ChatRoomProto.ChatRoomOpEnum.REMOVE, richCompletion));
    }

    @Override
    public void fetchMembers(final @NonNull ChatRoom chatRoom, final int n, final int n2, @NonNull HMR.CompletionArg<List<User>> completionArg) {
        final RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::fetchMembers");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetchMembers id:%s num:%s pos:%s", (Object[])new Object[]{chatRoom.getId(), n, n2}));
        HMRContext.work.async("ChatRoomService::fetchMembers", new Runnable(){

            @Override
            public void run() {
                ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchMemberList((int)chatRoom.getId(), n, n2, (RichCompletionArg<List<User>>)richCompletionArg));
            }
        });
    }

    @Override
    public void fetchRoleMembers(@NonNull ChatRoom chatRoom, boolean bl, @NonNull HMR.CompletionArg<Map<String, List<User>>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::fetchRoleMembers");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetch all roler Members id:%s, online:%s", (Object[])new Object[]{chatRoom.getId(), bl}));
        if (bl) {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchAdminList((int)chatRoom.getId(), "all", (RichCompletionArg<Map<String, List<User>>>)richCompletionArg));
        } else {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCPullAllAdminUser((int)chatRoom.getId(), "all", (RichCompletionArg<Map<String, List<User>>>)richCompletionArg));
        }
    }

    @Override
    public void fetchBasicInfo(@NonNull ChatRoom chatRoom, @NonNull HMR.CompletionArg<ChatRoomInfo> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatService::fetchBasicInfo");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetchBasicInfo id:%s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchChatRoomInfo((int)chatRoom.getId(), (RichCompletionArg<ChatRoomInfo>)richCompletionArg));
    }

    @Override
    public void changeBasicInfo(@NonNull ChatRoom chatRoom, @NonNull Map<ChatRoomInfo.BasicInfoType, String> map, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::changeBasicInfo");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"changeBasicInfo id:%s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomInfo((int)chatRoom.getId(), map, richCompletion));
    }

    @Override
    public void muteMember(@NonNull ChatRoom chatRoom, @NonNull User user, @Nullable String string, @NonNull HMR.Completion completion) {
        this.doMuteOrUnmute(chatRoom, user, string, true, completion);
    }

    @Override
    public void unmuteMember(@NonNull ChatRoom chatRoom, @NonNull User user, @Nullable String string, @NonNull HMR.Completion completion) {
        this.doMuteOrUnmute(chatRoom, user, string, false, completion);
    }

    private void doMuteOrUnmute(ChatRoom chatRoom, User user, String string, boolean bl, HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::doMuteOrUnmute");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)((bl ? "mute" : "unmute") + " id:%s member:%s"), (Object[])new Object[]{chatRoom.getId(), user.getId()}));
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCDisableUserText(HMR.getMe().getId(), user.getId(), (int)chatRoom.getId(), 259200L, bl, string == null ? "" : string, richCompletion));
    }

    @Override
    public void fetchMutedUsers(@NonNull ChatRoom chatRoom, @NonNull HMR.CompletionArg<Set<User>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::fetchMutedUsers");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetchMutedMembers roomId:%s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCFetchMutedMemberList((int)chatRoom.getId(), (RichCompletionArg<Set<User>>)richCompletionArg));
    }

    @Override
    public void isMuted(@NonNull ChatRoom chatRoom, final @NonNull User user, @NonNull HMR.CompletionArg<Boolean> completionArg) {
        final RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::isMuted");
        this.fetchMutedUsers(chatRoom, new HMR.CompletionArg<Set<User>>(){

            public void onSuccess(Set<User> set) {
                if (set.size() > 0 && set.contains(user)) {
                    CompletionUtils.dispatchSuccess((RichCompletionArg)richCompletionArg, (Object)true);
                } else {
                    CompletionUtils.dispatchSuccess((RichCompletionArg)richCompletionArg, (Object)false);
                }
            }

            public void onFailed(Error error) {
                CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)error);
            }
        });
    }

    @Override
    public void addListener(@NonNull ChatRoomService.ChatRoomListener chatRoomListener) {
        this.listeners.add(chatRoomListener);
        Log.d((String)TAG, (Object)Trace.once().method("addListener").info("name", (Object)chatRoomListener.getClass().getSimpleName()).info("size", (Object)this.listeners.size()));
    }

    @Override
    public void removeListener(@NonNull ChatRoomService.ChatRoomListener chatRoomListener) {
        this.listeners.remove(chatRoomListener);
        Log.d((String)TAG, (Object)Trace.once().method("removeListener").info("name", (Object)chatRoomListener.getClass().getSimpleName()).info("size", (Object)this.listeners.size()));
    }

    @Override
    public void addMemberListener(@NonNull ChatRoomService.MemberListener memberListener) {
        this.memberListeners.add(memberListener);
        Log.d((String)TAG, (Object)Trace.once().method("addMemberListener").info("name", (Object)memberListener.getClass().getSimpleName()).info("size", (Object)this.memberListeners.size()));
    }

    @Override
    public void removeMemberListener(@NonNull ChatRoomService.MemberListener memberListener) {
        this.memberListeners.remove(memberListener);
        Log.d((String)TAG, (Object)Trace.once().method("removeMemberListener").info("name", (Object)memberListener.getClass().getSimpleName()).info("size", (Object)this.memberListeners.size()));
    }

    public void onNotify(String string, String string2, byte[] byArray) {
        if ("chatroom_online_count_d".equals(string) && "UserCountBc".equals(string2)) {
            this.handleUserCountChanged(byArray);
        } else if ("chatroom_auther".equals(string) && "UpdateChatRoomInfoBc".equals(string2)) {
            this.handleBasicInfoChanged(byArray);
        } else if ("chatroom_auther".equals(string) && "UpdateRolerBc".equals(string2)) {
            this.handleMemberRoleChanged(byArray);
        } else if ("chatroom_auther".equals(string) && "KickOffUserBc".equals(string2)) {
            this.handleMemberKicked(byArray);
        } else if ("chatroom_auther".equals(string) && "DismissChatRoomBc".equals(string2)) {
            this.handleChatRoomDeleted(byArray);
        } else if ("chatroom_online_repair_d".equals(string) && "UserOnlineChangeBc".equals(string2)) {
            this.handleMembersChanged(byArray);
        } else if ("chatroom_auther".equals(string) && "DisableUserTextBc".equals(string2)) {
            this.handleChatMutation(byArray);
        }
    }

    private void handleChatMutation(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 272077) {
            return;
        }
        final ChatRoomProto.PCS_DisableUserTextBc pCS_DisableUserTextBc = new ChatRoomProto.PCS_DisableUserTextBc();
        receiver.unmarshallWrap((Marshallable)pCS_DisableUserTextBc);
        final ChatRoom chatRoom = new ChatRoom(pCS_DisableUserTextBc.roomid.longValue());
        final User user = new User(pCS_DisableUserTextBc.opUid.longValue());
        final HashSet<User> hashSet = new HashSet<User>();
        for (Uint64 uint64 : pCS_DisableUserTextBc.tuids) {
            hashSet.add(new User(uint64.longValue()));
        }
        DispatchQueue.main.async("ChatRoomService::handleChatMutation", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    if (pCS_DisableUserTextBc.disable) {
                        memberListener.onMemberMuted(chatRoom, user, hashSet, pCS_DisableUserTextBc.reason);
                        continue;
                    }
                    memberListener.onMemberUnmuted(chatRoom, user, hashSet, pCS_DisableUserTextBc.reason);
                }
            }
        });
    }

    private void handleMembersChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 3423949) {
            return;
        }
        ChatRoomProto.PCS_ChatRoomUserBc pCS_ChatRoomUserBc = new ChatRoomProto.PCS_ChatRoomUserBc();
        receiver.unmarshallWrap((Marshallable)pCS_ChatRoomUserBc);
        final ChatRoom chatRoom = new ChatRoom(pCS_ChatRoomUserBc.roomId.longValue());
        final ArrayList<User> arrayList = new ArrayList<User>();
        final ArrayList<User> arrayList2 = new ArrayList<User>();
        if (pCS_ChatRoomUserBc.joinUsers.size() > 0) {
            for (Uint64 uint64 : pCS_ChatRoomUserBc.joinUsers) {
                arrayList.add(new User(uint64.longValue()));
            }
        }
        if (pCS_ChatRoomUserBc.leaveUsers.size() > 0) {
            for (Uint64 uint64 : pCS_ChatRoomUserBc.leaveUsers) {
                arrayList2.add(new User(uint64.longValue()));
            }
        }
        DispatchQueue.main.async("ChatRoomService::handleMembersChanged", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    if (arrayList.size() > 0) {
                        Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("member join, size = " + arrayList.size())));
                        memberListener.onMemberJoined(chatRoom, arrayList);
                    }
                    if (arrayList2.size() <= 0) continue;
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("member leave, size = " + arrayList2.size())));
                    memberListener.onMemberLeaved(chatRoom, arrayList2);
                }
            }
        });
    }

    private void handleChatRoomDeleted(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 270285) {
            return;
        }
        final ChatRoomProto.PCS_DismissChatRoomBc pCS_DismissChatRoomBc = new ChatRoomProto.PCS_DismissChatRoomBc();
        receiver.unmarshallWrap((Marshallable)pCS_DismissChatRoomBc);
        DispatchQueue.main.async("ChatRoomService::handleChatRoomDeleted", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.ChatRoomListener chatRoomListener : ChatRoomServiceImpl.this.listeners) {
                    chatRoomListener.onChatRoomDismissed(new ChatRoom(pCS_DismissChatRoomBc.roomid.longValue()), new User(pCS_DismissChatRoomBc.uid.longValue()));
                }
            }
        });
    }

    private void handleMemberKicked(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 271053) {
            return;
        }
        ChatRoomProto.PCS_KickOffUserBc pCS_KickOffUserBc = new ChatRoomProto.PCS_KickOffUserBc();
        receiver.unmarshallWrap((Marshallable)pCS_KickOffUserBc);
        final ChatRoom chatRoom = new ChatRoom(pCS_KickOffUserBc.topsid.longValue());
        final User user = new User(pCS_KickOffUserBc.admin.longValue());
        final ArrayList<User> arrayList = new ArrayList<User>();
        for (Uint64 uint64 : pCS_KickOffUserBc.tuids) {
            arrayList.add(new User(uint64.longValue()));
        }
        final KickOff kickOff = new KickOff(pCS_KickOffUserBc.mReason, KickOffEnum.getByType(pCS_KickOffUserBc.type.intValue()));
        if (arrayList.contains(HMR.getMe())) {
            this._unsubscribeChatRoomBC(chatRoom);
        }
        DispatchQueue.main.async("ChatRoomService::handleMemberKicked", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    memberListener.onMemberKicked(chatRoom, user, arrayList, kickOff);
                }
            }
        });
    }

    private void handleMemberRoleChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 270797) {
            return;
        }
        final ChatRoomProto.PCS_UpdateChatRoomRolerBc pCS_UpdateChatRoomRolerBc = new ChatRoomProto.PCS_UpdateChatRoomRolerBc();
        receiver.unmarshallWrap((Marshallable)pCS_UpdateChatRoomRolerBc);
        if (ChatRoomProto.ChatRoomOpEnum.values()[pCS_UpdateChatRoomRolerBc.op.intValue()] != ChatRoomProto.ChatRoomOpEnum.ADD && ChatRoomProto.ChatRoomOpEnum.values()[pCS_UpdateChatRoomRolerBc.op.intValue()] != ChatRoomProto.ChatRoomOpEnum.REMOVE) {
            return;
        }
        final ChatRoom chatRoom = new ChatRoom(pCS_UpdateChatRoomRolerBc.roomid.longValue());
        final User user = new User(pCS_UpdateChatRoomRolerBc.uid.longValue());
        final User user2 = new User(pCS_UpdateChatRoomRolerBc.admin.longValue());
        final boolean bl = ChatRoomProto.ChatRoomOpEnum.values()[pCS_UpdateChatRoomRolerBc.op.intValue()] == ChatRoomProto.ChatRoomOpEnum.ADD;
        DispatchQueue.main.async("ChatRoomService::handleMemberRoleChanged", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    if (bl) {
                        memberListener.onRoleAdded(chatRoom, pCS_UpdateChatRoomRolerBc.roler, user2, user);
                        continue;
                    }
                    memberListener.onRoleRemoved(chatRoom, pCS_UpdateChatRoomRolerBc.roler, user2, user);
                }
            }
        });
    }

    private void handleBasicInfoChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 270541) {
            return;
        }
        ChatRoomProto.PCS_UpdateChatRoomInfoBc pCS_UpdateChatRoomInfoBc = new ChatRoomProto.PCS_UpdateChatRoomInfoBc();
        receiver.unmarshallWrap((Marshallable)pCS_UpdateChatRoomInfoBc);
        final ChatRoom chatRoom = new ChatRoom(pCS_UpdateChatRoomInfoBc.roomid.intValue());
        final HashMap<ChatRoomInfo.BasicInfoType, String> hashMap = new HashMap<ChatRoomInfo.BasicInfoType, String>();
        for (Map.Entry<String, String> entry : pCS_UpdateChatRoomInfoBc.props.entrySet()) {
            String string = entry.getKey();
            if ("Extention".equals(string)) {
                string = ChatRoomInfo.BasicInfoType.AppExtra.name();
            }
            hashMap.put(ChatRoomInfo.BasicInfoType.valueOf(string), entry.getValue());
        }
        DispatchQueue.main.async("ChatRoomService::handleBasicInfoChanged", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.ChatRoomListener chatRoomListener : ChatRoomServiceImpl.this.listeners) {
                    chatRoomListener.onBasicInfoChanged(chatRoom, hashMap);
                }
            }
        });
    }

    private void handleUserCountChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 3421389) {
            return;
        }
        ChatRoomProto.PCS_PushChatRoomUserCountBC pCS_PushChatRoomUserCountBC = new ChatRoomProto.PCS_PushChatRoomUserCountBC();
        receiver.unmarshallWrap((Marshallable)pCS_PushChatRoomUserCountBC);
        final ChatRoom chatRoom = new ChatRoom(pCS_PushChatRoomUserCountBC.topsid.longValue());
        final int n = pCS_PushChatRoomUserCountBC.totalCount.intValue();
        DispatchQueue.main.async("ChatRoomService::handleUserCountChanged", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    memberListener.onMemberCountChanged(chatRoom, n);
                }
            }
        });
    }

    private void addChatRoom(ChatRoom chatRoom) {
        this.chatRooms.add(chatRoom);
    }

    private void removeChatRoom(ChatRoom chatRoom) {
        this.chatRooms.remove((Object)chatRoom);
    }

    private void leaveChatRoom(final ChatRoom chatRoom, final RichCompletion richCompletion) {
        if (HMR.getMe().isAnonymous()) {
            this._unsubscribeChatRoomBC(chatRoom);
            CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
        } else {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCLeaveChatRoom((int)chatRoom.getId(), new RichCompletion("ChatRoomService::leaveChatRoom").onSuccess(new OnSuccess(){

                public void onSuccess() {
                    ChatRoomServiceImpl.this._unsubscribeChatRoomBC(chatRoom);
                    CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
                }
            }).onFailure(new OnFailure(){

                public void onFailure(Error error) {
                    CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)error);
                }
            })));
        }
    }

    private void _subscribeChatRoomBC(ChatRoom chatRoom, final @NonNull RichCompletion richCompletion) {
        final long l = chatRoom.getId();
        UserGroupType userGroupType = new UserGroupType(0x80000000L, l);
        UserGroupType userGroupType2 = new UserGroupType(0x80000001L, l);
        UserGroupType userGroupType3 = new UserGroupType(0x80000002L, l);
        ArrayList<UserGroupType> arrayList = new ArrayList<UserGroupType>();
        arrayList.add(userGroupType);
        arrayList.add(userGroupType2);
        arrayList.add(userGroupType3);
        YYServiceCore.getInstance().subscribeBroadcast(arrayList, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam>(){

            public void onSuccess(int n, BroadSubOrUnSubTask.ResponseParam responseParam) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("subscribeBroadcast success").msg("resCode:%d, roomId:%d", new Object[]{responseParam.mResCode, l}));
                CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
            }

            public void onFail(int n, int n2, int n3, Exception exception) {
                Log.e((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("subscribeBroadcast failed").msg("sdkResCode:%d, srvResCode:%d, roomId:%d", new Object[]{n2, n3, l}));
                CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(n3, "service err"));
            }
        });
    }

    private void _unsubscribeChatRoomBC(ChatRoom chatRoom) {
        final long l = chatRoom.getId();
        UserGroupType userGroupType = new UserGroupType(0x80000000L, l);
        UserGroupType userGroupType2 = new UserGroupType(0x80000001L, l);
        UserGroupType userGroupType3 = new UserGroupType(0x80000002L, l);
        ArrayList<UserGroupType> arrayList = new ArrayList<UserGroupType>();
        arrayList.add(userGroupType);
        arrayList.add(userGroupType2);
        arrayList.add(userGroupType3);
        YYServiceCore.getInstance().unSubscribeBroadcast(arrayList, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam>(){

            public void onSuccess(int n, BroadSubOrUnSubTask.ResponseParam responseParam) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("unSubscribeBroadcast success").msg("resCode:%d, roomId:%d", new Object[]{responseParam.mResCode, l}));
            }

            public void onFail(int n, int n2, int n3, Exception exception) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("unSubscribeBroadcast failed").msg("sdkResCode:%d, srvResCode:%d, roomId:%d", new Object[]{n2, n3, l}));
            }
        });
    }

    public void onChannelConnected() {
        Log.i((String)TAG, (Object)Trace.once().method("onChannelConnected"));
        this.rejoinChatRoomIfneed();
        this.resetInitialTimeInterval();
    }

    public void onChannelDisconnected() {
        Log.i((String)TAG, (Object)Trace.once().method("onChannelDisconnected"));
        this.recordInitialTimeIntervalIfNeeded();
    }

    private void rejoinChatRoomIfneed() {
        long l = System.currentTimeMillis();
        if (this.mInitialTimeInterval <= 946656000L || l - this.mInitialTimeInterval < 60000L) {
            return;
        }
        if (this.chatRooms.size() > 0) {
            for (ChatRoom chatRoom : this.chatRooms) {
                Log.i((String)TAG, (Object)String.format(Locale.US, "rejoin chatRoom after channel connected, roomId:%d", chatRoom.getId()));
                if (HMR.getMe() == null) continue;
                ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCJoinChatRoom((int)chatRoom.getId(), new HashMap<String, String>(), null));
            }
        }
    }

    private void recordInitialTimeIntervalIfNeeded() {
        if (this.mInitialTimeInterval < 946656000L) {
            this.mInitialTimeInterval = System.currentTimeMillis();
        }
    }

    private void resetInitialTimeInterval() {
        this.mInitialTimeInterval = 0L;
    }

    static interface NotifyHandler {
        public void handle(byte[] var1);
    }
}

