/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.ChatRoomServiceImpl;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import java.util.Map;

public class RPCPingChatRoom
extends ChatRoomRPC<ChatRoomProto.PCS_ChatRoomOnlineUserPingRes> {
    private final RichCompletion completion;
    private final int roomId;
    private Map<String, String> extension;

    public RPCPingChatRoom(int n, Map<String, String> map, RichCompletion richCompletion) {
        this.roomId = n;
        this.extension = map;
        this.completion = richCompletion;
    }

    public String getFunctionName() {
        return "OnlineUserHeartBeat";
    }

    public String getServiceName() {
        return ChatRoomServiceImpl.getServiceName("chatroom_heartbeat");
    }

    public Marshallable requestObj() {
        ChatRoomProto.PCS_ChatRoomOnlineUserPingReq pCS_ChatRoomOnlineUserPingReq = new ChatRoomProto.PCS_ChatRoomOnlineUserPingReq();
        pCS_ChatRoomOnlineUserPingReq.appid = Uint32.toUInt((long)HMRContext.appId);
        pCS_ChatRoomOnlineUserPingReq.roomid = Uint32.toUInt((int)this.roomId);
        pCS_ChatRoomOnlineUserPingReq.uid = Uint64.toUInt((long)HMR.getMe().getId());
        if (this.extension != null) {
            pCS_ChatRoomOnlineUserPingReq.ext = this.extension;
        }
        return pCS_ChatRoomOnlineUserPingReq;
    }

    public void handleSuccess(@NonNull ChatRoomProto.PCS_ChatRoomOnlineUserPingRes pCS_ChatRoomOnlineUserPingRes) {
        CompletionUtils.dispatchSuccess((RichCompletion)this.completion);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure((RichCompletion)this.completion, (Error)error);
    }
}

