package com.hummer.im.model.id;

public final class ChatRoom extends Identifiable {

    @Override
    public long getId() {
        return roomId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ChatRoom)) return false;

        return roomId == ((ChatRoom) o).getId();
    }

    @Override
    public int hashCode() {
        return Long.valueOf(roomId).hashCode();
    }

    @Override
    public String toString() {
        return "ChatRoom{" +
                "roomId=" + roomId +
                '}';
    }

    public ChatRoom(long id) {
        this.roomId = id;
    }

    private final long roomId;
}
