package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;

public class RPCSendUnicast extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCSendUnicast";

    public RPCSendUnicast(long roomId,
                          String content,
                          long receiver,
                          RichCompletion completion) {
        this.roomId = roomId;
        this.content = content;
        this.receiver = receiver;
        this.completion = completion;
    }

    @Override
    public String protoType() {
        return null;
    }

    @Override
    public String getFunctionName() {
        return "SendUnicast";
    }

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_SendUnicastReq req = new ChatRoomProto.PCS_SendUnicastReq();
        req.appKey   = Uint32.toUInt(HMRContext.getAppId());
        req.roomId   = Uint32.toUInt(roomId);
        req.uid      = Uint64.toUInt(HMR.getMe().getId());
        req.receiver = Uint64.toUInt(receiver);
        req.content  = this.content;

        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }
    private final long roomId;
    private final String content;
    private final long receiver;
    private final RichCompletion completion;
}
