package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;

import java.util.Map;

/**
 * 更新聊天室信息
 */

public class RPCChangeChatRoomInfo extends
        ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public RPCChangeChatRoomInfo(int roomId, Map<ChatRoomInfo.BasicInfoType, String> props,
                                 RichCompletion completion) {
        this.roomId = roomId;
        this.props  = props;
        this.mCompletion = completion;
    }

    @Override
    public String getFunctionName() {
        return "UpdateChatRoomInfo";
    }

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_UpdateChatRoomInfoReq req = new ChatRoomProto.PCS_UpdateChatRoomInfoReq();
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.roomid = Uint32.toUInt(roomId);
        req.uid = Uint64.toUInt(HMR.getMe().getId());

        for (Map.Entry<ChatRoomInfo.BasicInfoType, String> entry : props.entrySet()) {
            String key = entry.getKey().name();
            req.props.put(key, entry.getValue());
        }
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res) {
        CompletionUtils.dispatchSuccess(mCompletion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(mCompletion, err);
    }

    private final RichCompletion mCompletion;
    private final int roomId;
    private final Map<ChatRoomInfo.BasicInfoType, String> props;
}
