/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.ChatRoom;

public class RPCCreateChatRoom
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCCreateChatRoom";
    private final ChatRoomInfo chatRoomInfo;
    private final RichCompletionArg<ChatRoom> completion;

    public RPCCreateChatRoom(ChatRoomInfo chatRoomInfo, RichCompletionArg<ChatRoom> richCompletionArg) {
        this.chatRoomInfo = chatRoomInfo;
        this.completion = richCompletionArg;
    }

    public String getFunctionName() {
        return "CreateChatRoom";
    }

    public String getChatroomServiceName() {
        return "chatroom_auther";
    }

    public Marshallable requestObj() {
        ChatRoomProto.PCS_CreateChatRoomReq pCS_CreateChatRoomReq = new ChatRoomProto.PCS_CreateChatRoomReq();
        pCS_CreateChatRoomReq.appKey = Uint32.toUInt((long)HMRContext.appId);
        pCS_CreateChatRoomReq.uid = Uint64.toUInt((long)HMR.getMe().getId());
        if (this.chatRoomInfo.getName() != null) {
            pCS_CreateChatRoomReq.props.put(ChatRoomInfo.BasicInfoType.Name.name(), this.chatRoomInfo.getName());
        }
        if (this.chatRoomInfo.getDescription() != null) {
            pCS_CreateChatRoomReq.props.put(ChatRoomInfo.BasicInfoType.Description.name(), this.chatRoomInfo.getDescription());
        }
        if (this.chatRoomInfo.getBulletin() != null) {
            pCS_CreateChatRoomReq.props.put(ChatRoomInfo.BasicInfoType.Bulletin.name(), this.chatRoomInfo.getBulletin());
        }
        if (this.chatRoomInfo.getAppExtra() != null) {
            pCS_CreateChatRoomReq.props.put(ChatRoomInfo.BasicInfoType.AppExtra.name(), this.chatRoomInfo.getAppExtra());
        }
        return pCS_CreateChatRoomReq;
    }

    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        CompletionUtils.dispatchSuccess(this.completion, (Object)((Object)new ChatRoom(pCS_CommonOperatorAuth2Res.roomId.longValue())));
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, (Error)error);
    }
}

