/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.HMR;
import com.hummer.im.chatroom.Challenges;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.id.ChatRoom;
import com.hummer.im.model.id.User;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ChatRoomService {
    public void switchRegion(String var1);

    public void createChatRoom(@NonNull ChatRoomInfo var1, @NonNull HMR.CompletionArg<ChatRoom> var2);

    public void dismissChatRoom(@NonNull ChatRoom var1, @Nullable HMR.Completion var2);

    public void join(@NonNull ChatRoom var1, @NonNull Map<String, String> var2, @NonNull Challenges.JoiningCompletion var3);

    public void leave(@NonNull ChatRoom var1, @Nullable HMR.Completion var2);

    public void kick(@NonNull ChatRoom var1, @NonNull User var2, @Nullable Map<EKickInfo, String> var3, @NonNull HMR.Completion var4);

    public void addRole(@NonNull ChatRoom var1, @NonNull User var2, @NonNull String var3, @NonNull HMR.Completion var4);

    public void removeRole(@NonNull ChatRoom var1, @NonNull User var2, @NonNull String var3, @NonNull HMR.Completion var4);

    public void fetchMembers(@NonNull ChatRoom var1, int var2, int var3, @NonNull HMR.CompletionArg<List<User>> var4);

    public void fetchRoleMembers(@NonNull ChatRoom var1, boolean var2, @NonNull HMR.CompletionArg<Map<String, List<User>>> var3);

    public void fetchBasicInfo(@NonNull ChatRoom var1, @NonNull HMR.CompletionArg<ChatRoomInfo> var2);

    public void changeBasicInfo(@NonNull ChatRoom var1, @NonNull Map<ChatRoomInfo.BasicInfoType, String> var2, @NonNull HMR.Completion var3);

    public void muteMember(@NonNull ChatRoom var1, @NonNull User var2, @Nullable String var3, @NonNull HMR.Completion var4);

    public void unmuteMember(@NonNull ChatRoom var1, @NonNull User var2, @Nullable String var3, @NonNull HMR.Completion var4);

    public void fetchMutedUsers(@NonNull ChatRoom var1, @NonNull HMR.CompletionArg<Set<User>> var2);

    public void isMuted(@NonNull ChatRoom var1, @NonNull User var2, @NonNull HMR.CompletionArg<Boolean> var3);

    public void addListener(@NonNull ChatRoomListener var1);

    public void removeListener(@NonNull ChatRoomListener var1);

    public void addMemberListener(@NonNull MemberListener var1);

    public void removeMemberListener(@NonNull MemberListener var1);

    public static final class Signal
    extends Content {
        public final User user;
        public final String content;

        public static Signal unicast(@NonNull User user, @NonNull String string) {
            return new Signal(user, string);
        }

        public static Signal broadcast(@NonNull String string) {
            return new Signal(null, string);
        }

        private Signal(User user, @NonNull String string) {
            this.user = user;
            this.content = string;
        }

        public String toString() {
            return "ChatRoom.Signal{" + this.content + "}";
        }
    }

    public static interface MemberListener {
        public void onMemberJoined(@NonNull ChatRoom var1, @NonNull List<User> var2);

        public void onMemberLeaved(@NonNull ChatRoom var1, @NonNull List<User> var2);

        public void onMemberCountChanged(@NonNull ChatRoom var1, int var2);

        public void onRoleAdded(@NonNull ChatRoom var1, @NonNull String var2, @NonNull User var3, @NonNull User var4);

        public void onRoleRemoved(@NonNull ChatRoom var1, @NonNull String var2, @NonNull User var3, @NonNull User var4);

        public void onMemberKicked(@NonNull ChatRoom var1, @NonNull User var2, @NonNull List<User> var3, @NonNull String var4);

        public void onMemberMuted(@NonNull ChatRoom var1, @NonNull User var2, @NonNull Set<User> var3, @Nullable String var4);

        public void onMemberUnmuted(@NonNull ChatRoom var1, @NonNull User var2, @NonNull Set<User> var3, @Nullable String var4);
    }

    public static interface ChatRoomListener {
        public void onBasicInfoChanged(@NonNull ChatRoom var1, @NonNull Map<ChatRoomInfo.BasicInfoType, String> var2);

        public void onChatRoomDismissed(@NonNull ChatRoom var1, @NonNull User var2);
    }

    public static final class Roles {
        public static final String Admin = "admin";
        public static final String Owner = "owner";
    }

    public static enum EKickInfo {
        Time,
        Reason;

    }
}

