package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.User;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public final class RPCPullAllAdminUser extends
        ChatRoomRPC<ChatRoomProto.PCS_ChatRoomManagerRes> {
    public RPCPullAllAdminUser(int roomid, String role,
                               CompletionArg<Map<String, List<User>>> completion) {
        this.roomid = roomid;
        this.role = role;
        this.mCompletion = completion;
    }

    @Override
    public String getFunctionName() {
        return "GetChatRoomManager";
    }

    @Override
    public String serviceName() {
        return "chatroom_smember";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_ChatRoomManagerReq req = new ChatRoomProto.PCS_ChatRoomManagerReq();
        req.roomId = Uint32.toUInt(roomid);
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.role = role;
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_ChatRoomManagerRes res) throws Throwable {
        HashMap<String, List<User>> resultMap = new HashMap<>();
        if (res.admins.size() > 0) {
            for (Map.Entry<String, ArrayList<Uint64>> entry : res.admins.entrySet()) {
                String key = entry.getKey();
                List<User> fellows = new ArrayList<>();
                List<Uint64> uids = res.admins.get(key);
                for (Uint64 uid : uids) {
                    User fellow = new User(uid.longValue());
                    fellows.add(fellow);
                }
                resultMap.put(key, fellows);
            }
        }
        CompletionUtils.dispatchSuccess(mCompletion, resultMap);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(mCompletion, err);
    }

    private final CompletionArg<Map<String, List<User>>> mCompletion;
    private final int roomid;
    private final String role;
}
