package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;


public class RPCCreateChatRoom extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCCreateChatRoom";

    public RPCCreateChatRoom(ChatRoomInfo chatRoomInfo,
                             CompletionArg<ChatRoom> completion) {
        this.chatRoomInfo = chatRoomInfo;
        this.completion = completion;
    }

    @Override
    public String getFunctionName() {
        return "CreateChatRoom";
    }

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_CreateChatRoomReq req = new ChatRoomProto.PCS_CreateChatRoomReq();
        req.appKey = Uint32.toUInt(HMRContext.appId);
        req.uid    = Uint64.toUInt(HMR.getMe().getId());

        if (chatRoomInfo.getName() != null) {
            req.props.put("Name", chatRoomInfo.getName());
        }

        if (chatRoomInfo.getDescription() != null) {
            req.props.put("Description", chatRoomInfo.getDescription());
        }

        if (chatRoomInfo.getBulletin() != null) {
            req.props.put("Bulletin", chatRoomInfo.getBulletin());
        }

        if (chatRoomInfo.getAppExtra() != null) {
            req.props.put("Extention", chatRoomInfo.getAppExtra());
        }
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res)
            throws Throwable {
        CompletionUtils.dispatchSuccess(completion, new ChatRoom(res.roomId.longValue()));
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private final ChatRoomInfo chatRoomInfo;
    private final CompletionArg<ChatRoom> completion;
}
