package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.channel.Channel;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.packet.Sender;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.shared.HiidoReporter;

import junit.framework.Assert;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;

public abstract class ChatRoomRPC<Response extends Marshallable> implements Channel.RPC {

    public abstract Marshallable requestObj();

    public abstract void handleSuccess(@NonNull Response res) throws Throwable;

    @Override
    public String protoType() {
        return null;
    }

    @Override
    public byte[] getRequestBytes() throws Throwable {
        Sender sender = new Sender(requestObj());
        sender.endPack();
        startTs = System.currentTimeMillis();
        return sender.getBytes();
    }

    @Override
    public void handleResponse(@NonNull byte[] responseBytes) throws Throwable {
        Class responseClass = (Class) ((ParameterizedType) this.getClass()
                .getGenericSuperclass())
                .getActualTypeArguments()[0];

        Response res = (Response) responseClass.newInstance();
        Receiver receiver = new Receiver(responseBytes);
        receiver.unmarshallWrap2(res);

        Field resCodeField = null;
        try {
            resCodeField = res.getClass().getDeclaredField("res");
        } catch (Exception e) {
            resCodeField = res.getClass().getDeclaredField("rescode");
        }

        Assert.assertNotNull(resCodeField);

        int resCode = ((Uint32) resCodeField.get(res)).intValue();
        Assert.assertNotNull(resCode);

        Log.i(TAG, Trace.once().method("ChatRoomRPC.handleResponse")
                .info("code", resCode));

        long rtt = System.currentTimeMillis() - startTs;
        if (resCode == Error.Code.Success) {
            handleSuccess(res);
        } else {
            handleError(res, new Error(resCode, "service error"));
        }

        HiidoReporter.reportReturnCodeTemporary(getFunctionName(), rtt, resCode);
    }

    public void handleError(@Nullable Response res, @NonNull Error error) {
        handleError(error);
    }

    private long startTs;
    private static final String TAG = "ChatRoomRPC";
}
