package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ScopeSignal;
import com.hummer.im.id.User;
import com.hummer.im.services.mq.MQService;
import com.hummer.im.services.notification.NotificationMessage;

public class UnicastMsgParser implements MQService.BCMessageParser {

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public String functionName() {
        return "SendUnicastUc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_SendUnicastUc.uri) {
            return null;
        }

        ChatRoomProto.PCS_SendUnicastUc bc = new ChatRoomProto.PCS_SendUnicastUc();
        receiver.unmarshallWrap(bc);

        User sender = new User(bc.uid.longValue());
        ScopeSignal scopeSignal = new ScopeSignal(bc.roomId.longValue());

        return new NotificationMessage(sender, scopeSignal, bc.content);
    }
}