package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;

import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.User;
import com.hummer.im.services.mq.MQService;

public class ChatRoomDismissMsgParser implements MQService.BCMessageParser {

    public class ChatRoomDismissMsg implements HMR.Message {
        public ChatRoom chatRoom;
        public User operator;

        public ChatRoomDismissMsg(ChatRoom chatRoom, User operator) {
            this.chatRoom = chatRoom;
            this.operator = operator;
        }
    }

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public String functionName() {
        return "DismissChatRoomBc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_DismissChatRoomBc.uri) {
            return null;
        }

        ChatRoomProto.PCS_DismissChatRoomBc bc = new ChatRoomProto.PCS_DismissChatRoomBc();
        receiver.unmarshallWrap(bc);
        return new ChatRoomDismissMsg(new ChatRoom(bc.roomid.longValue()),
                new User(bc.uid.longValue()));
    }
}
