package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ScopeAll;
import com.hummer.im.id.User;
import com.hummer.im.services.mq.MQService;
import com.hummer.im.services.notification.NotificationMessage;

public class BroadcastMsgParser implements MQService.BCMessageParser {

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public String functionName() {
        return "SendBroadcastBc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_SendBroadcastBc.uri) {
            return null;
        }

        ChatRoomProto.PCS_SendBroadcastBc bc = new ChatRoomProto.PCS_SendBroadcastBc();
        receiver.unmarshallWrap(bc);

        User sender = new User(bc.uid.longValue());
        ScopeAll scopeAll = new ScopeAll(bc.roomId.longValue());

        return new NotificationMessage(sender, scopeAll, bc.content);
    }
}
