package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.User;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;

import java.util.LinkedList;
import java.util.List;

public class RPCFetchMemberList extends ChatRoomRPC<ChatRoomProto.PCS_PullOnlineUserListRes> {
    public RPCFetchMemberList(int roomId, int num, int pos, CompletionArg<List<User>> completion) {
        this.roomId = roomId;
        this.num    = num;
        this.pos    = pos;
        this.completion = completion;
    }

    @Override
    public String getFunctionName() {
        return "GetUserList";
    }

    @Override
    public String serviceName() {
        return "chatroom_online_query_d";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_PullOnlineUserListReq req = new ChatRoomProto.PCS_PullOnlineUserListReq();
        req.roomid = Uint32.toUInt(roomId);
        //TODO 此处需要进行确认
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.num = Uint32.toUInt(num);
        req.pos = Uint32.toUInt(pos);
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_PullOnlineUserListRes res) throws Throwable {
        List<User> resultMap = new LinkedList<>();
        for (Uint64 uid : res.users) {
            resultMap.add(new User(uid.longValue()));
        }

        CompletionUtils.dispatchSuccess(completion, resultMap);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private final CompletionArg<List<User>> completion;
    private final int roomId;
    private final int num;
    private final int pos;
}
