package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;


public class RPCDismissChatRoom extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public RPCDismissChatRoom(int roomId, CompletionArg<ChatRoom> completion) {
        this.roomId = roomId;
        this.mCompletion = completion;
    }

    @Override
    public String getFunctionName() {
        return "DismissChatRoom";
    }

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_DismissChatRoomReq req = new ChatRoomProto.PCS_DismissChatRoomReq();
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.roomid = Uint32.toUInt(roomId);
        req.uid = Uint64.toUInt(HMR.getMe().getId());
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res)
            throws Throwable {
        CompletionUtils.dispatchSuccess(mCompletion,
                new ChatRoom(res.roomId.longValue()));
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(mCompletion, err);
    }

    private final CompletionArg<ChatRoom> mCompletion;

    private final int roomId;
}
