package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.User;


public class MemberUpdateRoleMsgParser implements MQService.BCMessageParser {
    public class MemberUpdateRoleMsg implements HMR.Message {
        public ChatRoom chatRoom;
        public User user;
        public User admin;
        public Boolean isAdd;
        public String role;

        public MemberUpdateRoleMsg(ChatRoom chatRoom, User user, User admin, String role,
                                   Boolean isAdd) {
            this.chatRoom = chatRoom;
            this.user = user;
            this.admin = admin;
            this.role = role;
            this.isAdd = isAdd;
        }
    }

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public String functionName() {
        return "UpdateRolerBc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_UpdateChatRoomRolerBc.uri) {
            return null;
        }

        ChatRoomProto.PCS_UpdateChatRoomRolerBc bc =
                new ChatRoomProto.PCS_UpdateChatRoomRolerBc();
        receiver.unmarshallWrap(bc);

        if (ChatRoomProto.ChatRoomOpEnum.values()[bc.op.intValue()] !=
                ChatRoomProto.ChatRoomOpEnum.ADD &&
                ChatRoomProto.ChatRoomOpEnum.values()[bc.op.intValue()] !=
                        ChatRoomProto.ChatRoomOpEnum.REMOVE) {
            return null;
        }

        ChatRoom chatRoom = new ChatRoom(bc.roomid.longValue());
        Boolean isAdd = ChatRoomProto.ChatRoomOpEnum.values()[bc.op.intValue()] ==
                ChatRoomProto.ChatRoomOpEnum.ADD;
        return new MemberUpdateRoleMsg(chatRoom, new User(bc.uid.longValue()),
                new User(bc.admin.longValue()), bc.roler, isAdd);
    }
}
