package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;

public class MemberCountChangeMsgParser implements MQService.BCMessageParser {

    public class MemberCountChangeMsg implements HMR.Message {
        public int count;
        public ChatRoom chatRoom;

        public MemberCountChangeMsg(ChatRoom chatRoom, int count) {
            this.chatRoom = chatRoom;
            this.count = count;
        }
    }

    @Override
    public String serviceName() {
        return "chatroom_online_count_d";
    }

    @Override
    public String functionName() {
        return "UserCountBc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_PushChatRoomUserCountBC.uri) {
            return null;
        }

        ChatRoomProto.PCS_PushChatRoomUserCountBC bc =
                new ChatRoomProto.PCS_PushChatRoomUserCountBC();
        receiver.unmarshallWrap(bc);

        return new MemberCountChangeMsg(new ChatRoom(bc.topsid.longValue()),
                bc.totalCount.intValue());
    }
}
