package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.User;

import java.util.ArrayList;
import java.util.List;

public class MemberChangeMsgParser implements MQService.BCMessageParser {
    private static final String TAG = "MemberChangeMsgParser";

    public class MemberChangeMsg implements HMR.Message {
        public ChatRoom chatRoom;
        public List<User> users;
        public Boolean isJoin;

        MemberChangeMsg(ChatRoom chatRoom, List<User> users, Boolean isJoin) {
            this.chatRoom = chatRoom;
            this.users = users;
            this.isJoin = isJoin;
        }
    }

    @Override
    public String serviceName() {
        return "chatroom_online_repair_d";
    }

    @Override
    public String functionName() {
        return "UserOnlineChangeBc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_ChatRoomUserBc.uri) {
            return null;
        }

        ChatRoomProto.PCS_ChatRoomUserBc bc =
                new ChatRoomProto.PCS_ChatRoomUserBc();
        receiver.unmarshallWrap(bc);

        ChatRoom chatRoom = new ChatRoom(bc.roomId.longValue());

        if (bc.joinUsers.size() > 0) {
            ArrayList<User> joins = new ArrayList<>();
            for (Uint64 uid : bc.joinUsers) {
                Log.i(TAG, Trace
                        .once().method("parse").msg("parse and add join use, uid = " + uid));
                joins.add(new User(uid.longValue()));
            }
            return new MemberChangeMsg(chatRoom, joins, true);
        } else if (bc.leaveUsers.size() > 0) {
            ArrayList<User> leaves = new ArrayList<>();
            for (Uint64 uid : bc.leaveUsers) {
                Log.i(TAG, Trace
                        .once().method("parse").msg("parse and add leave use, uid = " + uid));
                leaves.add(new User(uid.longValue()));
            }
            return new MemberChangeMsg(chatRoom, leaves, false);
        }
        return null;
    }
}
