package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.User;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class RPCFetchAdminList extends ChatRoomRPC<ChatRoomProto.PCS_PullAdminUserRes> {

    public RPCFetchAdminList(int roomId, String role, CompletionArg<Map<String, List<User>>> completion) {
        this.roomId = roomId;
        this.role       = role;
        this.completion = completion;
    }

    @Override
    public String serviceName() {
        return "chatroom_online_query_d";
    }

    @Override
    public String getFunctionName() {
        return "GetRolerList";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_PullAdminUserReq req = new ChatRoomProto.PCS_PullAdminUserReq();
        req.roomId = Uint32.toUInt(roomId);
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.role   = role;
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_PullAdminUserRes res) throws Throwable {
        HashMap<String, List<User>> resultMap = new HashMap<>();
        for (Map.Entry<String, ArrayList<Uint64>> entry : res.admins.entrySet()) {
            String key = entry.getKey();
            List<User> fellows = new ArrayList<>();
            List<Uint64> uids = res.admins.get(key);
            for (Uint64 uid : uids) {
                User user = new User(uid.longValue());
                fellows.add(user);
            }
            resultMap.put(key, fellows);
        }
        CompletionUtils.dispatchSuccess(completion, resultMap);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private final int roomId;
    private final String role;
    private final CompletionArg<Map<String, List<User>>> completion;
}
