package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;

import java.util.HashMap;
import java.util.Map;

public class UpdateChatRoomMsgParser implements MQService.BCMessageParser {

    public static class UpdateChatRoomMsg implements HMR.Message {
        public ChatRoom chatRoom;
        public Map<ChatRoomInfo.BasicInfoType, String> changeBasicInfoMap;

        public UpdateChatRoomMsg(ChatRoom chatRoom,
                                 Map<ChatRoomInfo.BasicInfoType, String> changeBasicInfoMap) {
            this.chatRoom = chatRoom;
            this.changeBasicInfoMap = changeBasicInfoMap;
        }
    }

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public String functionName() {
        return "UpdateChatRoomInfoBc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_UpdateChatRoomInfoBc.uri) {
            return null;
        }

        ChatRoomProto.PCS_UpdateChatRoomInfoBc bc = new ChatRoomProto.PCS_UpdateChatRoomInfoBc();
        receiver.unmarshallWrap(bc);
        ChatRoom chatRoom = new ChatRoom(bc.roomid.intValue());
        Map<ChatRoomInfo.BasicInfoType, String> changeBasicInfoMap = new HashMap<>();
        for (Map.Entry<String, String> entry : bc.props.entrySet()) {
            String key = entry.getKey();
            if (key.equals("Extention")) {
                key = "AppExtra";
            }
            changeBasicInfoMap
                    .put(ChatRoomInfo.BasicInfoType.valueOf(key), entry.getValue());
        }


        return new UpdateChatRoomMsg(chatRoom, changeBasicInfoMap);
    }
}
