package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.User;

import java.util.ArrayList;
import java.util.List;

public class KickOffMembersMsgParser implements MQService.BCMessageParser {

    public class KickOffMembersMsg implements HMR.Message {
        public ChatRoom chatRoom;
        public List<User> kickedUsers;
        public User admin;
        public String reason;

        public KickOffMembersMsg(ChatRoom chatRoom, List<User> kickedUsers, User admin, String reason) {
            this.chatRoom = chatRoom;
            this.kickedUsers = kickedUsers;
            this.admin = admin;
            this.reason = reason;
        }
    }

    @Override
    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public String functionName() {
        return "KickOffUserBc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_KickOffUserBc.uri) {
            return null;
        }

        ChatRoomProto.PCS_KickOffUserBc bc =
                new ChatRoomProto.PCS_KickOffUserBc();
        receiver.unmarshallWrap(bc);
        ChatRoom chatRoom = new ChatRoom(bc.topsid.longValue());
        User admin = new User(bc.admin.longValue());
        ArrayList<User> tuids = new ArrayList<>();
        for (Uint64 uid : bc.tuids) {
            tuids.add(new User(uid.longValue()));
        }

        return new KickOffMembersMsg(chatRoom, tuids, admin, bc.mReason);
    }
}
