package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.User;
import com.hummer.im.services.chat.ChatMessage;
import com.hummer.im.services.chat.ChatMessageStates;
import com.hummer.im.services.chat.contents.Text;


public class ChatRoomTextChatMsgParser implements MQService.BCMessageParser {
    @Override
    public String serviceName() {
        return "chatroom_textchat";
    }

    @Override
    public String functionName() {
        return "TextChatBc";
    }

    @Override
    public HMR.Message parse(byte[] data) {
        Receiver receiver = new Receiver(data);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != ChatRoomProto.PCS_TextChatBc.uri) {
            return null;
        }

        ChatRoomProto.PCS_TextChatBc bc = new ChatRoomProto.PCS_TextChatBc();
        receiver.unmarshallWrap(bc);

        ChatRoom chatRoom = new ChatRoom(bc.roomId.longValue());
        Text text = new Text(bc.chat);
        ChatMessage chatMessage = new ChatMessage(chatRoom, text);
        chatMessage.setState(new ChatMessageStates.Archived());
        chatMessage.setSender(new User(bc.uid.longValue()));
        chatMessage.setUuid(bc.chatProps.get("uuid"));
        chatMessage.setAppExtra(bc.chatProps.get("extra"));
        chatMessage.setTimestamp(System.currentTimeMillis());
        return chatMessage;
    }
}
