package com.hummer.im.model.fetch;

import com.hummer.im.model.chat.Message;

import java.util.Set;

public class FetchingParams {
    /**
     * 消息类型, 必填。{@link MsgType}, 目前只有TEXT一种类型
     */
    private Set<MsgType> msgTypes;

    /**
     * 消息锚点. 为null则表示从最新消息开始查询
     */
    private Message anchor;

    /**
     * 查询方向 {@link Direction}
     */
    private Direction direction;

    /**
     * 消息条数: 每次最多查询100条. limit>100时, 当100处理; <1时, 当1处理
     */
    private int limit;

    public Set<MsgType> getMsgTypes() {
        return msgTypes;
    }

    public FetchingParams setMsgTypes(Set<MsgType> msgTypes) {
        this.msgTypes = msgTypes;
        return this;
    }

    public Message getAnchor() {
        return anchor;
    }

    public FetchingParams setAnchor(Message anchor) {
        this.anchor = anchor;
        return this;
    }

    public Direction getDirection() {
        return direction;
    }

    public FetchingParams setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public int getLimit() {
        return limit;
    }

    public FetchingParams setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public String toString() {
        return "FetchingParams{" +
                "msgTypes=" + msgTypes +
                ", anchor=" + anchor +
                ", direction=" + direction +
                ", limit=" + limit +
                '}';
    }
}
