package com.hummer.im.chatroom.model.user;

import com.hummer.im.model.id.User;

public class UserJoinInfo {
    /**
     * 用户
     */
    private User user;

    /**
     * 加入聊天室时的时间戳
     */
    private long timestamp;

    public UserJoinInfo(User user, long timestamp) {
        this.user = user;
        this.timestamp = timestamp;
    }

    public User getUser() {
        return user;
    }

    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserJoinInfo userJoinInfo = (UserJoinInfo) o;

        if (timestamp != userJoinInfo.timestamp) {
            return false;
        }
        return user != null ? user.equals(userJoinInfo.user) : userJoinInfo.user == null;
    }

    @Override
    public int hashCode() {
        int result = user != null ? user.hashCode() : 0;
        result = 31 * result + (int) (timestamp ^ (timestamp >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "UserJoinInfo{" +
                "user=" + user +
                ", timestamp=" + timestamp +
                '}';
    }
}
