package com.hummer.im.chatroom.model.user;

import java.util.Map;

public class FetchRoomUserAttributesResult {

    /**
     * 聊天室用户属性
     */
    private final Map<String, String> attributes;

    /**
     * 最后一次更新用户属性的时间
     */
    private final long latestUpdateTs;

    public FetchRoomUserAttributesResult(Map<String, String> attributes, long latestUpdateTs) {
        this.attributes = attributes;
        this.latestUpdateTs = latestUpdateTs;
    }

    public Map<String, String> getAttributes() {
        return attributes;
    }

    public long getLatestUpdateTs() {
        return latestUpdateTs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        FetchRoomUserAttributesResult that = (FetchRoomUserAttributesResult) o;

        if (latestUpdateTs != that.latestUpdateTs) {
            return false;
        }
        return attributes != null ? attributes.equals(that.attributes) : that.attributes == null;
    }

    @Override
    public int hashCode() {
        int result = attributes != null ? attributes.hashCode() : 0;
        result = 31 * result + (int) (latestUpdateTs ^ (latestUpdateTs >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "FetchRoomUserAttributesResult{" +
                "attributes=" + attributes +
                ", latestUpdateTs=" + latestUpdateTs +
                '}';
    }
}
