package com.hummer.im.chatroom.model.mute;

import com.hummer.im.model.id.User;

public class UserMuteStatus {

    /**
     * 查询的用户
     */
    private final User user;

    /**
     * 是否禁言
     */
    private final boolean isMuted;

    /**
     * 禁言剩余时间，单位秒
     */
    private final long unmuteTime;

    public UserMuteStatus(User user, boolean isMuted, long unmuteTime) {
        this.user = user;
        this.isMuted = isMuted;
        this.unmuteTime = unmuteTime;
    }

    public User getUser() {
        return user;
    }

    public boolean getIsMuted() {
        return isMuted;
    }

    public long getUnmuteTime() {
        return unmuteTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserMuteStatus that = (UserMuteStatus) o;

        if (isMuted != that.isMuted) {
            return false;
        }
        if (unmuteTime != that.unmuteTime) {
            return false;
        }
        return user != null ? user.equals(that.user) : that.user == null;
    }

    @Override
    public int hashCode() {
        int result = user != null ? user.hashCode() : 0;
        result = 31 * result + (isMuted ? 1 : 0);
        result = 31 * result + (int) (unmuteTime ^ (unmuteTime >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "UserMuteStatus{" +
                "user=" + user +
                ", isMuted=" + isMuted +
                ", unmuteTime=" + unmuteTime +
                '}';
    }
}
