package com.hummer.im.chatroom.model.attribute;

import com.hummer.im.model.id.User;

import java.util.Map;

public class FetchRoomBasicAttributesResult {
    /**
     * 聊天室基础属性
     */
    private Map<String, String> attributes;

    /**
     * 最后一次更新基础属性的操作用户
     */
    private User operator;

    /**
     * 最后一次更新基础属性的时间
     */
    private long latestUpdateTs;


    public FetchRoomBasicAttributesResult(Map<String, String> attributes, User operator, long latestUpdateTs) {
        this.attributes = attributes;
        this.operator = operator;
        this.latestUpdateTs = latestUpdateTs;
    }

    public Map<String, String> getAttributes() {
        return attributes;
    }

    public User getOperator() {
        return operator;
    }

    public long getLatestUpdateTs() {
        return latestUpdateTs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        FetchRoomBasicAttributesResult that = (FetchRoomBasicAttributesResult) o;

        if (latestUpdateTs != that.latestUpdateTs) {
            return false;
        }
        if (attributes != null ? !attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        return operator != null ? operator.equals(that.operator) : that.operator == null;
    }

    @Override
    public int hashCode() {
        int result = attributes != null ? attributes.hashCode() : 0;
        result = 31 * result + (operator != null ? operator.hashCode() : 0);
        result = 31 * result + (int) (latestUpdateTs ^ (latestUpdateTs >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "FetchRoomBasicAttributesResult{" +
                "attributes=" + attributes +
                ", operator=" + operator +
                ", latestUpdateTs=" + latestUpdateTs +
                '}';
    }
}
