package com.hummer.im.chatroom.model.attribute;

import com.hummer.im.model.id.User;

import java.util.Map;

public class ChatRoomExtraAttribute {

    /**
     * 聊天室属性
     */
    private Map<String, String> attributes;

    /**
     * 操作用户
     */
    private User user;

    /**
     * 房间属性最近一次设置的时间戳
     */
    private long latestUpdateTs;

    public ChatRoomExtraAttribute(Map<String, String> attributes, User user, long latestUpdateTs) {
        this.attributes = attributes;
        this.user = user;
        this.latestUpdateTs = latestUpdateTs;
    }

    public Map<String, String> getAttributes() {
        return attributes;
    }

    public long getLatestUpdateTs() {
        return latestUpdateTs;
    }

    public User getUser() {
        return user;
    }

    @Override
    public String toString() {
        return "ChatRoomExtraAttribute{" +
                "attributes=" + attributes +
                ", user=" + user +
                ", latestUpdateTs=" + latestUpdateTs +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ChatRoomExtraAttribute that = (ChatRoomExtraAttribute) o;

        if (latestUpdateTs != that.latestUpdateTs){
            return false;
        }
        if (attributes != null ? !attributes.equals(that.attributes) : that.attributes != null){
            return false;
        }
        return user != null ? user.equals(that.user) : that.user == null;
    }

    @Override
    public int hashCode() {
        int result = attributes != null ? attributes.hashCode() : 0;
        result = 31 * result + (user != null ? user.hashCode() : 0);
        result = 31 * result + (int) (latestUpdateTs ^ (latestUpdateTs >>> 32));
        return result;
    }
}
