package com.hummer.im.chatroom._internals.helper;

import com.hummer.im.chatroom.model.attribute.ChatRoomExtraAttribute;
import com.hummer.im.chatroom.model.attribute.FetchRoomBasicAttributesResult;
import com.hummer.im.chatroom.model.kick.KickOutType;
import com.hummer.im.model.fetch.FetchingResult;
import com.hummer.im.model.id.ChatRoom;
import com.hummer.im.model.id.User;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChatRoomNotification {

    // ChatRoom callback
    public static final int NOTIFY_ON_CREATE_CHAT_ROOM = 401;//创建房间
    public static final int NOTIFY_ON_DISMISS_CHAT_ROOM = 402;//解散房间
    public static final int NOTIFY_ON_FETCH_BASIC_INFO = 403;//"获取聊天室基本属性信息",
    public static final int NOTIFY_ON_CHANGE_BASIC_INFO = 404;//"修改聊天室基本信息",
    public static final int NOTIFY_ON_FETCH_MEMBER_COUNT = 406;//"获取聊天室人数",

    /**
     * 查询聊天室扩展属性回调
     */
    public static final int NOTIFY_ON_FETCH_ROOM_EXTRA_ATTRIBUTES_RESULT = 441;
    /**
     * 设置聊天室扩展属性回调
     */
    public static final int NOTIFY_ON_SET_ROOM_EXTRA_ATTRIBUTES_RESULT = 442;
    /**
     * 更新聊天室扩展属性回调
     */
    public static final int NOTIFY_ON_UPDATE_ROOM_EXTRA_ATTRIBUTES_RESULT = 443;
    /**
     * 删除聊天室扩展属性回调
     */
    public static final int NOTIFY_ON_DELETE_ROOM_EXTRA_ATTRIBUTES_RESULT = 444;
    /**
     * 清空聊天室扩展属性回调
     */
    public static final int NOTIFY_ON_CLEAR_ROOM_EXTRA_ATTRIBUTES_RESULT = 445;
    /** 查询聊天室基础信息回调 */
    public static final int NOTIFY_ON_FETCH_ROOM_BASIC_ATTRIBUTES_RESULT = 446;


    /// ChatRoom notify [409, 440]

    public static final int NOTIFY_ON_CHAT_ROOM_DISMISSED = 409;
    public static final int NOTIFY_ON_BASIC_INFO_CHANGED = 410;

    /**
     * 聊天室扩展属性设置通知
     */
    public static final int NOTIFY_ON_ROOM_EXTRA_ATTRIBUTES_SET = 412;
    /**
     * 聊天室扩展属性更新通知
     */
    public static final int NOTIFY_ON_ROOM_EXTRA_ATTRIBUTES_UPDATED = 413;
    /**
     * 聊天室扩展属性删除通知
     */
    public static final int NOTIFY_ON_ROOM_EXTRA_ATTRIBUTES_DELETED = 414;
    /**
     * 聊天室扩展属性清空通知
     */
    public static final int NOTIFY_ON_ROOM_EXTRA_ATTRIBUTES_CLEARED = 415;

    // ChatRoom Member
    public static final int NOTIFY_ON_JOIN_CHAT_ROOM = 501;//加入房间
    public static final int NOTIFY_ON_EXIT_CHAT_ROOM = 502;//退出房间
    public static final int NOTIFY_ON_KICK = 503;//踢出房间
    public static final int NOTIFY_ON_ADD_ROLE = 504;//"添加权限角色",
    public static final int NOTIFY_ON_REMOVE_ROLE = 505;//"移除权限角色",
    public static final int NOTIFY_ON_FETCH_MEMBERS = 506;//"获取成员列表",
    public static final int NOTIFY_ON_FETCH_ROLE_MEMBERS = 507;//"获取带有角色的成员列表",
    public static final int NOTIFY_ON_MUTE_MEMBER = 508;//"禁言聊天室内的成员",
    public static final int NOTIFY_ON_UN_MUTE_MEMBER = 509;//"解禁成员聊天室内的成员",
    public static final int NOTIFY_ON_FETCH_MUTED_USERS = 510;//"获取禁言列表",
    public static final int NOTIFY_ON_IS_MUTED = 511;//"判别用户是否被禁言",
    public static final int NOTIFY_ON_SET_USER_INFO = 512;//"设置自己的用户信息",
    public static final int NOTIFY_ON_DELETE_USER_INFO_BY_KEYS = 513;//"删除自己的用户信息",
    public static final int NOTIFY_ON_ADD_OR_UPDATE_USER_INFO = 514;//"添加或更新指定用户信息",
    public static final int NOTIFY_ON_FETCH_USER_INFO = 515;//"获取指定用户的用户信息",
    public static final int NOTIFY_ON_BATCH_FETCH_USER_INFO = 516;//"批量获取指定用户的用户信息",
    public static final int NOTIFY_ON_FETCH_ONLINE_USER_INFO_LIST = 517;//"获取聊天室已设置用户信息的在线成员列
    /**
     * 查询在聊天室内带角色的用户列表
     */
    public static final int NOTIFY_ON_FETCH_ROOM_USERS_BY_ROLE = 518;
    /**
     * 查询用户角色
     */
    public static final int NOTIFY_ON_FETCH_USER_ROLE = 561;


    /// ChatRoom Member notify [519, 560]
    public static final int NOTIFY_ON_MEMBER_JOINED = 519;
    public static final int NOTIFY_ON_ROOM_MEMBER_OFFLINE = 520;
    public static final int NOTIFY_ON_ROOM_MEMBER_LEAVED = 521;
    public static final int NOTIFY_ON_MEMBER_COUNT_CHANGED = 522;
    public static final int NOTIFY_ON_MEMBER_KICKED = 523;
    public static final int NOTIFY_ON_ROLE_ADDED = 524;
    public static final int NOTIFY_ON_ROLE_REMOVED = 525;
    public static final int NOTIFY_ON_MEMBER_MUTED = 526;
    public static final int NOTIFY_ON_MEMBER_UN_MUTED = 527;
    public static final int NOTIFY_ON_USER_INFO_SET = 528;
    public static final int NOTIFY_ON_USER_INFO_DELETED = 529;
    public static final int NOTIFY_ON_USER_INFO_ADD_OR_UPDATED = 530;
    public static final int NOTIFY_ON_USER_KICKED = 531;

    // ChatRoom message

    /**
     * 查询聊天室历史消息回调
     */
    public static final int NOTIFY_ON_FETCH_HISTORY_MESSAGES = 601;

    public static class BaseInfo {
        public long requestId;
        public int code;
        public String desc;

        public long getRequestId() {
            return requestId;
        }

        public void setRequestId(long requestId) {
            this.requestId = requestId;
        }

        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public static class BaseCallbackInfo extends BaseInfo {

        public BaseCallbackInfo(long requestId, int code, String desc) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
        }
    }


    public static class OnCreateChatRoom extends BaseInfo {
        private ChatRoom chatRoom;

        public OnCreateChatRoom(long requestId, int code, String desc, long roomId) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.chatRoom = new ChatRoom(roomId);
        }

        @Override
        public long getRequestId() {
            return requestId;
        }

        @Override
        public int getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }
    }

    public static class OnJoinRoom extends BaseInfo {
        private long roomId;
        private Map<String, String> joinProps;

        public OnJoinRoom(long requestId, int code, String desc, long roomId,
                          Map<String, String> joinProps) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            this.joinProps = joinProps;
        }
    }

    public static class OnLeaveRoom extends BaseInfo {
        private long roomId;

        public OnLeaveRoom(long requestId, int code, String desc, long roomId) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
        }
    }

    public static class OnFetchUserRole extends BaseInfo {
        private long roomId;
        private String role;

        public OnFetchUserRole(long requestId, int code, String desc, long roomId, String role) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            this.role = role;
        }

        public String getRole() {
            return role;
        }
    }

    public static class OnFetchMembers extends BaseInfo {
        private long roomId;
        private List<User> users;

        public OnFetchMembers(long requestId, int code, String desc, long roomId, Set<Long> uids) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            if (uids != null) {
                users = new ArrayList<>();
                for (Long uid : uids) {
                    this.users.add(new User(uid));
                }
            }
        }

        public List<User> getUsers() {
            return users;
        }
    }

    public static class OnFetchRoleMembers extends BaseInfo {
        private long roomId;
        private Map<String, List<User>> users;

        public OnFetchRoleMembers(long requestId, int code, String desc, long roomId, Map<String, List<User>> users) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            this.users = users;
        }

        public Map<String, List<User>> getUsers() {
            return users;
        }
    }

    public static class OnFetchMemberCount extends BaseInfo {
        private long roomId;
        private int count;

        public OnFetchMemberCount(long requestId, int code, String desc, long roomId, int count) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            this.count = count;
        }

        public int getCount() {
            return count;
        }
    }

    public static class OnRoomProps extends BaseInfo {
        private long roomId;
        private Map<String, String> props;

        public OnRoomProps(long requestId, int code, String desc, long roomId, Map<String, String> props) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            this.props = props;
        }

        public Map<String, String> getProps() {
            return props;
        }
    }


    public static class OnFetchMutedUsers extends BaseInfo {
        private long roomId;
        private Set<User> users;

        public OnFetchMutedUsers(long requestId, int code, String desc, long roomId, Set<Long> uids) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            if (uids != null) {
                users = new HashSet<>();
                for (Long uid : uids) {
                    users.add(new User(uid));
                }
            }
        }

        public Set<User> getUsers() {
            return users;
        }
    }

    public static class OnIsMuted extends BaseInfo {
        private long roomId;
        private boolean muted;

        public OnIsMuted(long requestId, int code, String desc, long roomId, boolean muted) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            this.muted = muted;
        }

        public boolean getMuted() {
            return muted;
        }
    }

    public static class OnUserInfoList extends BaseInfo {
        private long roomId;
        private Map<User, Map<String, String>> userInfoMap;

        public OnUserInfoList(long requestId, int code, String desc, long roomId, Map<User, Map<String, String>> userInfoMap) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            this.userInfoMap = userInfoMap;
        }

        public Map<User, Map<String, String>> getUserInfoMap() {
            return userInfoMap;
        }
    }

    public static class OnFetchHistoryMessages extends BaseInfo {
        private FetchingResult fetchingResult;

        public OnFetchHistoryMessages(long requestId, int code, String desc, FetchingResult fetchingResult) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.fetchingResult = fetchingResult;
        }

        public FetchingResult getFetchingResult() {
            return fetchingResult;
        }
    }

    public static class OnFetchUserInfo extends BaseInfo {
        private long roomId;
        private Map<String, String> userInfoMap;

        public OnFetchUserInfo(long requestId, int code, String desc, long roomId, Map<String, String> userInfoMap) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.roomId = roomId;
            this.userInfoMap = userInfoMap;
        }

        public Map<String, String> getUserInfoMap() {
            return userInfoMap;
        }
    }

    public static class OnBasicInfoChanged {
        private ChatRoom chatRoom;
        private User user;
        private Map<String, String> props;
        private long latestUpdateTs;

        public OnBasicInfoChanged(long roomId, long uid, Map<String, String> props, long latestUpdateTs) {
            this.chatRoom = new ChatRoom(roomId);
            this.user = new User(uid);
            this.props = props;
            this.latestUpdateTs = latestUpdateTs;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public User getUser() {
            return user;
        }

        public Map<String, String> getProps() {
            return props;
        }

        public long getLatestUpdateTs() {
            return latestUpdateTs;
        }
    }

    public static class OnFetchRoomBasicAttributesResult extends BaseInfo {
        private FetchRoomBasicAttributesResult result;

        public OnFetchRoomBasicAttributesResult(long requestId,
                                                int code,
                                                String desc,
                                                long roomId,
                                                Map<String, String> attributes,
                                                long userId,
                                                long updateTimestamp) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.result = new FetchRoomBasicAttributesResult(attributes, new User(userId), updateTimestamp);
        }

        public FetchRoomBasicAttributesResult getResult() {
            return result;
        }
    }

    public static class OnFetchRoomExtraAttributesResult extends BaseInfo {
        private ChatRoomExtraAttribute chatRoomExtraAttribute;

        public OnFetchRoomExtraAttributesResult(long requestId,
                                                int code,
                                                String desc,
                                                long roomId,
                                                Map<String, String> attributes,
                                                long userId,
                                                long updateTimestamp) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.chatRoomExtraAttribute = new ChatRoomExtraAttribute(attributes, new User(userId), updateTimestamp);
        }

        public ChatRoomExtraAttribute getChatRoomExtraAttribute() {
            return chatRoomExtraAttribute;
        }
    }

    public static class OnSetRoomExtraAttributesResult extends BaseInfo {

        public OnSetRoomExtraAttributesResult(long requestId,
                                              int code,
                                              String desc,
                                              long roomId,
                                              Map<String, String> attributes) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
        }
    }

    public static class OnUpdateRoomExtraAttributesResult extends BaseInfo {

        public OnUpdateRoomExtraAttributesResult(long requestId,
                                                 int code,
                                                 String desc,
                                                 long roomId,
                                                 Map<String, String> attributes) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
        }
    }

    public static class OnDeleteRoomExtraAttributesResult extends BaseInfo {

        public OnDeleteRoomExtraAttributesResult(long requestId,
                                                 int code,
                                                 String desc,
                                                 long roomId,
                                                 Set<String> keys) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
        }
    }

    public static class OnClearRoomExtraAttributesResult extends BaseInfo {

        public OnClearRoomExtraAttributesResult(long requestId,
                                                int code,
                                                String desc,
                                                long roomId) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
        }
    }

    public static class OnRoomExtraAttributesChanged extends BaseInfo {
        private ChatRoom chatRoom;
        private Map<String, String> attributes;
        private User user;
        private long latestUpdateTs;

        public OnRoomExtraAttributesChanged(long roomId, Map<String, String> attributes, long userId, long updateTimestamp) {
            this.chatRoom = new ChatRoom(roomId);
            this.attributes = attributes;
            this.user = new User(userId);
            this.latestUpdateTs = updateTimestamp;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public Map<String, String> getAttributes() {
            return attributes;
        }

        public User getUser() {
            return user;
        }

        public long getLatestUpdateTs() {
            return latestUpdateTs;
        }
    }

    public static class OnMemberJoined {
        private ChatRoom chatRoom;
        private List<User> members;

        public OnMemberJoined(long roomId, List<User> members) {
            this.chatRoom = new ChatRoom(roomId);
            this.members = members;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public List<User> getMembers() {
            return members;
        }
    }

    public static class OnMemberCountChanged {
        private ChatRoom chatRoom;
        private int count;

        public OnMemberCountChanged(long roomId, int count) {
            this.chatRoom = new ChatRoom(roomId);
            this.count = count;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public int getCount() {
            return count;
        }
    }

    public static class OnMemberKicked {
        private ChatRoom chatRoom;
        private User user;
        private List<User> users;
        private String reason;
        private int kickType;

        public OnMemberKicked(long roomId, User user, List<User> users, String reason, int kickType) {
            this.chatRoom = new ChatRoom(roomId);
            this.user = user;
            this.users = users;
            this.reason = reason;
            this.kickType = kickType;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public User getUser() {
            return user;
        }

        public List<User> getUsers() {
            return users;
        }

        public String getReason() {
            return reason;
        }

        public int getKickType() {
            return kickType;
        }
    }

    public static class OnUserKicked {
        private ChatRoom chatRoom;
        private User user;
        private KickOutType kickOutType;
        private Map<String, String> extraInfo;

        public OnUserKicked(long roomId, User user, int kickOutType, Map<String, String> extraInfo) {
            this.chatRoom = new ChatRoom(roomId);
            this.user = user;
            // 避免engine的定义和平台层的不一致，故遍历所有结果
            switch (kickOutType) {
                case 0:
                    this.kickOutType = KickOutType.KICK_OUT;
                    break;
                case 1:
                    this.kickOutType = KickOutType.MULTI_JOIN;
                    break;
                case 2:
                    this.kickOutType = KickOutType.BAN;
                    break;
                case 3:
                    this.kickOutType = KickOutType.ROOM_DISMISS;
                    break;
                default:
                    this.kickOutType = KickOutType.UNDEFINED;
            }

            this.extraInfo = extraInfo;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public User getUser() {
            return user;
        }

        public KickOutType getKickOutType() {
            return kickOutType;
        }

        public Map<String, String> getExtraInfo() {
            return extraInfo;
        }
    }

    public static class OnRoleAdded {
        private ChatRoom chatRoom;
        private String role;
        private User admin;
        private User fellow;

        public OnRoleAdded(long roomId, String role, long admin, long fellow) {
            this.chatRoom = new ChatRoom(roomId);
            this.role = role;
            this.admin = new User(admin);
            this.fellow = new User(fellow);
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public String getRole() {
            return role;
        }

        public User getAdmin() {
            return admin;
        }

        public User getFellow() {
            return fellow;
        }
    }

    public static class OnMemberMuted {
        private ChatRoom chatRoom;
        private User operatorUser;
        private Set<User> members;
        private String reason;

        public OnMemberMuted(long roomId, User operatorUser, Set<User> members, String reason) {
            this.chatRoom = new ChatRoom(roomId);
            this.operatorUser = operatorUser;
            this.members = members;
            this.reason = reason;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public User getOperatorUser() {
            return operatorUser;
        }

        public Set<User> getMembers() {
            return members;
        }

        public String getReason() {
            return reason;
        }
    }

    public static class OnUserInfoSet {
        private ChatRoom chatRoom;
        private User user;
        private Map<String, String> infoMap;

        public OnUserInfoSet(long roomId, long userId, Map<String, String> infoMap) {
            this.chatRoom = new ChatRoom(roomId);
            this.user = new User(userId);
            this.infoMap = infoMap;
        }

        public ChatRoom getChatRoom() {
            return chatRoom;
        }

        public User getUser() {
            return user;
        }

        public Map<String, String> getInfoMap() {
            return infoMap;
        }
    }


}
