package com.hummer.im.chatroom._internals.helper;

import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom.ChatRoomService;
import com.hummer.im.chatroom.model.attribute.ChatRoomAttributeOptions;
import com.hummer.im.chatroom.model.attribute.RoomBasicAttributesOptions;
import com.hummer.im.chatroom.model.kick.KickUserOptions;
import com.hummer.im.model.fetch.FetchingParams;
import com.hummer.im.model.id.ChatRoom;
import com.hummer.im.model.id.User;

import java.util.Map;
import java.util.Set;

public class ChatRoomNative {

    /****************************************** RoomService begin *******************************/
    public static long addMessageListener() {
        return HummerNative.nativeAddMessageListener();
    }

    public static long removeMessageListener() {
        return HummerNative.nativeRemoveMessageListener();
    }

    public static long addMemberListener() {
        return HummerNative.nativeAddMemberListener();
    }

    public static long removeMemberListener() {
        return HummerNative.nativeRemoveMemberListener();
    }

    public static long addRoomListener() {
        return HummerNative.nativeAddRoomListener();
    }

    public static long removeRoomListener() {
        return HummerNative.nativeRemoveRoomListener();
    }

    public static long setRegion(String region) {
        return HummerNative.sdkProcess(new ChatRoomEvent.EventSetRegion(region));
    }

    public static long createRoom(long requestId, ChatRoomInfo chatRoomInfo) {
        return HummerNative
                .sdkProcess(new ChatRoomEvent.EventCreateChatRoom(requestId, chatRoomInfo));
    }

    public static long dismissRoom(long requestId, ChatRoom chatRoom) {
        ChatRoomEvent.EventChatRoom event = new ChatRoomEvent.EventChatRoom(requestId, chatRoom);
        event.event = ChatRoomEvent.EVENT_ROOM_DISMISS_ROOM;
        return HummerNative.sdkProcess(event);
    }

    public static long joinRoom(long requestId, ChatRoom chatRoom, Map<String, String> joinProps) {
        return HummerNative.sdkProcess(new ChatRoomEvent.EventJoinRoom(requestId, chatRoom
                , joinProps));
    }

    public static long exitRoom(long requestId, ChatRoom chatRoom) {
        ChatRoomEvent.EventChatRoom event = new ChatRoomEvent.EventChatRoom(requestId, chatRoom);
        event.event = ChatRoomEvent.EVENT_ROOM_EXIT_ROOM;
        return HummerNative.sdkProcess(event);
    }

    @Deprecated
    public static long kick(long requestId, ChatRoom chatRoom, User member,
                            Map<ChatRoomService.EKickInfo, String> extraInfo) {
        ChatRoomEvent.EventKick event = new ChatRoomEvent.EventKick(requestId, chatRoom, member, extraInfo);
        return HummerNative.sdkProcess(event);
    }

    public static void kickUser(long requestId, ChatRoom chatRoom, User member,
                                Map<String, String> extraInfo, KickUserOptions options) {
        ChatRoomEvent.EventKickUser event = new ChatRoomEvent.EventKickUser(requestId, chatRoom, member, extraInfo, options);
        HummerNative.sdkProcess(event);
    }

    public static void setUserRole(long requestId, ChatRoom chatRoom, User member, String role) {
        ChatRoomEvent.EventRole event = new ChatRoomEvent.EventRole(requestId, chatRoom, member, role);
        event.event = ChatRoomEvent.EVENT_ROOM_SET_USER_ROLE;
        HummerNative.sdkProcess(event);
    }

    public static long addRole(long requestId, ChatRoom chatRoom, User member, String role) {
        ChatRoomEvent.EventRole event = new ChatRoomEvent.EventRole(requestId, chatRoom, member, role);
        event.event = ChatRoomEvent.EVENT_ROOM_ADD_ROLE;
        return HummerNative.sdkProcess(event);
    }

    public static void deleteUserRole(long requestId, ChatRoom chatRoom, User member) {
        // 新旧兼容，协议需要传，那为了代码复用，role就传一个空字符串，后台不会解析改字段
        ChatRoomEvent.EventRole event = new ChatRoomEvent.EventRole(requestId, chatRoom, member, "");
        event.event = ChatRoomEvent.EVENT_ROOM_DELETE_USER_ROLE;
        HummerNative.sdkProcess(event);
    }

    public static long removeRole(long requestId, ChatRoom chatRoom, User member, String role) {
        ChatRoomEvent.EventRole event = new ChatRoomEvent.EventRole(requestId, chatRoom, member, role);
        event.event = ChatRoomEvent.EVENT_ROOM_REMOVE_ROLE;
        return HummerNative.sdkProcess(event);
    }

    public static long fetchMembers(long requestId, ChatRoom chatRoom, int num, int offset) {
        ChatRoomEvent.EventFetchMembers event = new ChatRoomEvent.EventFetchMembers(requestId, chatRoom, num, offset);
        return HummerNative.sdkProcess(event);
    }

    public static long fetchUserRole(long requestId, ChatRoom chatRoom, User user) {
        ChatRoomEvent.EventFetchUserRole event = new ChatRoomEvent.EventFetchUserRole(requestId, chatRoom, user);
        return HummerNative.sdkProcess(event);
    }

    public static long fetchRoomUsersByRole(long requestId, ChatRoom chatRoom, String role) {
        ChatRoomEvent.EventFetchRoomUsersByRole event = new ChatRoomEvent.EventFetchRoomUsersByRole(requestId, chatRoom, role);
        return HummerNative.sdkProcess(event);
    }

    public static long fetchRoleMembers(long requestId, ChatRoom chatRoom, boolean online) {
        ChatRoomEvent.EventFetchRoleMembers event = new ChatRoomEvent.EventFetchRoleMembers(requestId, chatRoom, online);
        return HummerNative.sdkProcess(event);
    }

    public static long fetchMemberCount(long requestId, ChatRoom chatRoom) {
        ChatRoomEvent.EventChatRoom event = new ChatRoomEvent.EventChatRoom(requestId, chatRoom);
        event.event = ChatRoomEvent.EVENT_ROOM_FETCH_MEMBER_COUNT;
        return HummerNative.sdkProcess(event);
    }

    public static long fetchBasicInfo(long requestId, ChatRoom chatRoom) {
        ChatRoomEvent.EventChatRoom event = new ChatRoomEvent.EventChatRoom(requestId, chatRoom);
        event.event = ChatRoomEvent.EVENT_ROOM_FETCH_BASIC_INFO;
        return HummerNative.sdkProcess(event);
    }

    public static void fetchRoomBasicAttributes(long requestId, ChatRoom chatRoom, Set<String> keys) {
        ChatRoomEvent.EventFetchRoomBasicAttributes event = new ChatRoomEvent.EventFetchRoomBasicAttributes(requestId, chatRoom, keys);
        HummerNative.sdkProcess(event);
    }

    @Deprecated
    public static long changeBasicInfo(long requestId, ChatRoom chatRoom,
                                       Map<ChatRoomInfo.BasicInfoType, String> propInfo) {

        ChatRoomEvent.EventChangeBasicInfo event = new ChatRoomEvent.EventChangeBasicInfo(requestId, chatRoom, propInfo);
        return HummerNative.sdkProcess(event);
    }

    public static void updateRoomBasicAttributes(long requestId,
                                                 ChatRoom chatRoom,
                                                 Map<String, String> attributes,
                                                 RoomBasicAttributesOptions options) {
        ChatRoomEvent.EventUpdateRoomBasicAttributes event = new ChatRoomEvent.EventUpdateRoomBasicAttributes(requestId, chatRoom, attributes, options);
        HummerNative.sdkProcess(event);
    }

    public static long fetchRoomExtraAttributes(long requestId, ChatRoom chatRoom, Set<String> keys) {
        ChatRoomEvent.EventFetchRoomExtraAttributes event = new ChatRoomEvent.EventFetchRoomExtraAttributes(requestId, chatRoom, keys);
        return HummerNative.sdkProcess(event);
    }

    public static long setRoomExtraAttributes(long requestId, ChatRoom chatRoom, Map<String, String> attributes, ChatRoomAttributeOptions options) {
        ChatRoomEvent.EventSetRoomExtraAttributes event = new ChatRoomEvent.EventSetRoomExtraAttributes(requestId, chatRoom, attributes, options);
        return HummerNative.sdkProcess(event);
    }

    public static long updateRoomExtraAttributes(long requestId, ChatRoom chatRoom, Map<String, String> attributes, ChatRoomAttributeOptions options) {
        ChatRoomEvent.EventUpdateRoomExtraAttributes event = new ChatRoomEvent.EventUpdateRoomExtraAttributes(requestId, chatRoom, attributes, options);
        return HummerNative.sdkProcess(event);
    }

    public static long deleteRoomExtraAttributes(long requestId, ChatRoom chatRoom, Set<String> keys, ChatRoomAttributeOptions options) {
        ChatRoomEvent.EventDeleteRoomExtraAttributes event = new ChatRoomEvent.EventDeleteRoomExtraAttributes(requestId, chatRoom, keys, options);
        return HummerNative.sdkProcess(event);
    }

    public static long clearRoomExtraAttributes(long requestId, ChatRoom chatRoom, ChatRoomAttributeOptions options) {
        ChatRoomEvent.EventClearRoomExtraAttributes event = new ChatRoomEvent.EventClearRoomExtraAttributes(requestId, chatRoom, options);
        return HummerNative.sdkProcess(event);
    }

    public static long muteMember(long requestId, ChatRoom chatRoom, User member, String reason) {
        ChatRoomEvent.EventMuteMember event = new ChatRoomEvent.EventMuteMember(requestId, chatRoom, member, reason);
        return HummerNative.sdkProcess(event);
    }

    public static long unMuteMember(long requestId, ChatRoom chatRoom, User member, String reason) {
        ChatRoomEvent.EventMuteMember event = new ChatRoomEvent.EventMuteMember(requestId, chatRoom, member, reason);
        event.event = ChatRoomEvent.EVENT_ROOM_UN_MUTE_MEMBER;
        return HummerNative.sdkProcess(event);
    }

    public static long fetchMutedUsers(long requestId, ChatRoom chatRoom) {
        ChatRoomEvent.EventChatRoom event = new ChatRoomEvent.EventChatRoom(requestId, chatRoom);
        event.event = ChatRoomEvent.EVENT_ROOM_FETCH_MUTED_USERS;
        return HummerNative.sdkProcess(event);
    }

    public static long isMuted(long requestId, ChatRoom chatRoom, User member) {
        ChatRoomEvent.EventMuteMember event = new ChatRoomEvent.EventMuteMember(requestId, chatRoom, member, null);
        event.event = ChatRoomEvent.EVENT_ROOM_IS_MUTED;
        return HummerNative.sdkProcess(event);
    }

    public static long setUserInfo(long requestId, ChatRoom chatRoom, Map<String, String> infoMap) {
        ChatRoomEvent.EventUserInfo event = new ChatRoomEvent.EventUserInfo(requestId, chatRoom, infoMap);
        event.event = ChatRoomEvent.EVENT_ROOM_SET_USER_INFO;
        return HummerNative.sdkProcess(event);
    }

    public static long deleteUserInfoByKeys(long requestId, ChatRoom chatRoom, Set<String> keys) {
        ChatRoomEvent.EventDeleteUserInfoByKeys event = new ChatRoomEvent.EventDeleteUserInfoByKeys(requestId, chatRoom, keys);
        return HummerNative.sdkProcess(event);
    }

    public static long addOrUpdateUserInfo(long requestId, ChatRoom chatRoom, Map<String, String> infoMap) {
        ChatRoomEvent.EventUserInfo event = new ChatRoomEvent.EventUserInfo(requestId, chatRoom, infoMap);
        event.event = ChatRoomEvent.EVENT_ROOM_ADD_OR_UPDATE_USER_INFO;
        return HummerNative.sdkProcess(event);
    }

    public static long fetchUserInfo(long requestId, ChatRoom chatRoom, User member) {
        ChatRoomEvent.EventFetchUserInfo event = new ChatRoomEvent.EventFetchUserInfo(requestId, chatRoom, member);
        return HummerNative.sdkProcess(event);

    }

    public static long fetchOnlineUserInfoList(long requestId, ChatRoom chatRoom) {
        ChatRoomEvent.EventChatRoom event = new ChatRoomEvent.EventChatRoom(requestId, chatRoom);
        event.event = ChatRoomEvent.EVENT_ROOM_FETCH_ONLINE_USER_INFO_LIST;
        return HummerNative.sdkProcess(event);
    }

    public static long batchFetchUserInfos(long requestId, ChatRoom chatRoom, Set<User> users) {
        ChatRoomEvent.EventBatchFetchUserInfos event = new ChatRoomEvent.EventBatchFetchUserInfos(requestId, chatRoom, users);
        return HummerNative.sdkProcess(event);
    }

    public static long fetchHistoryMessages(long requestId, ChatRoom chatRoom, FetchingParams params) {
        ChatRoomEvent.EventFetchHistoryMessages event = new ChatRoomEvent.EventFetchHistoryMessages(requestId, chatRoom, params);
        return HummerNative.sdkProcess(event);
    }
}
