package com.hummer.im.chatroom._internals;


import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.chatroom.ChatRoomService;
import com.hummer.im.model.id.ChatRoom;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.IDType;
import com.hummer.im.model.id.Identifiable;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SPChatRoomModuleLoader implements ServiceProvider.ModuleLoader {
    @Override
    public void initModule() {
        registerIdentifiableExtension();
    }

    @Override
    public void deInitModule() {

    }

    @Override
    public Map<Class, ServiceProvider.Service> getServices() {
        return new HashMap<Class, ServiceProvider.Service>(2, 1) {{
            put(ChatRoomService.class, new ChatRoomServiceImpl());
        }};
    }

    public static void registerIdentifiableExtension() {
        IDFactory.registerExtension(new IDFactory.Extension() {
            @Override
            public Identifiable makeId(String idString) {
                if (idString.matches("^chatRoom_\\d+$")) {
                    return new ChatRoom(Long.parseLong(idString.substring(9)));
                }
                return null;
            }

            @Override
            public String makeString(Identifiable id) {
                if (id instanceof ChatRoom) {
                    return String.format(Locale.US, "%s_%d", "chatRoom", id.getId());
                }

                return null;
            }

            @Override
            public IDType makeType(Identifiable id) {
                if (id instanceof ChatRoom) {
                    return IDType.CHAT_ROOM;
                }

                return null;
            }
        });
    }
}
