package com.hummer.im.chatroom;
import androidx.annotation.NonNull;

import com.hummer.im.Error;

public final class Challenges {

    public interface Challenge {
    }

    public interface Password extends Challenge {
        void setPassword(String password);
    }

    public interface AppChallenge extends Challenge {
        void setChallenge(String appExtra);
    }

    public interface JoiningCompletion {

        void onSucceed();
        void onFailure(@NonNull Error error);

        /**
         * 如果进入频道启用了质疑选项，或者系统认为请求存在可疑行为（例如机器人），会通过onReceiveXXXChallenge
         * 回调收到一个质疑回调。接入方在收到该回调时，应
         */
        void onReceiveChallenge(Password challenge);
        void onReceiveChallenge(AppChallenge challenge);
    }

    public interface JoiningCompletionArg<Argument> {

        void onSucceed(Argument arg);
        void onFailure(@NonNull Error error);

        /**
         * 如果进入频道启用了质疑选项，或者系统认为请求存在可疑行为（例如机器人），会通过onReceiveXXXChallenge
         * 回调收到一个质疑回调。接入方在收到该回调时，应
         */
        void onReceiveChallenge(Password challenge);
        void onReceiveChallenge(AppChallenge challenge);
    }

}