/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.channel._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.channel._internals.proto.ChannelYYProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;
import java.util.ArrayList;
import java.util.List;

public final class RPCFetchMembersByAttr
extends ChatRoomRPC<ChannelYYProto.PCS_ChannelServiceUserListWithPropertyRes> {
    private String channelId;
    private String key;
    private String prop;
    private RichCompletionArg<List<User>> completion;
    private static final String TAG = "RPCFetchMembersByAttr";

    public RPCFetchMembersByAttr(String string, String string2, String string3, RichCompletionArg<List<User>> richCompletionArg) {
        this.channelId = string;
        this.key = string2;
        this.prop = string3;
        this.completion = richCompletionArg;
    }

    public String getChatroomServiceName() {
        return "channel_service_query";
    }

    public String getFunctionName() {
        return "GetSpecificUserList";
    }

    public Marshallable requestObj() {
        ChannelYYProto.PCS_ChannelServiceUserListWithPropertyReq pCS_ChannelServiceUserListWithPropertyReq = new ChannelYYProto.PCS_ChannelServiceUserListWithPropertyReq();
        pCS_ChannelServiceUserListWithPropertyReq.appid = Uint32.toUInt((long)HMRContext.appId);
        pCS_ChannelServiceUserListWithPropertyReq.channelId = this.channelId;
        pCS_ChannelServiceUserListWithPropertyReq.key = this.key;
        pCS_ChannelServiceUserListWithPropertyReq.prop = this.prop;
        return pCS_ChannelServiceUserListWithPropertyReq;
    }

    public void handleSuccess(@NonNull ChannelYYProto.PCS_ChannelServiceUserListWithPropertyRes pCS_ChannelServiceUserListWithPropertyRes) {
        Log.i((String)TAG, (Object)Trace.once().info("users.size", (Object)pCS_ChannelServiceUserListWithPropertyRes.users.size()));
        ArrayList<User> arrayList = new ArrayList<User>();
        for (Uint64 uint64 : pCS_ChannelServiceUserListWithPropertyRes.users) {
            arrayList.add(new User(uint64.longValue()));
        }
        CompletionUtils.dispatchSuccess(this.completion, arrayList);
    }

    public void handleError(@NonNull Error error) {
        Log.i((String)TAG, (Object)Trace.once().info("error", (Object)error));
        CompletionUtils.dispatchFailure(this.completion, (Error)error);
    }
}

