/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.channel._internals.rpc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.Signal;
import com.hummer.im.model.channel.CSMessage;
import com.hummer.im.model.channel.SendingOptions;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.User;

public class RPCSendP2PSignalMessage
extends IMRPC<Signal.P2PSignalRequest, Signal.P2PSignalRequest.Builder, Signal.P2PSignalResponse> {
    private final CSMessage mCSMessage;
    private final SendingOptions mSendingOptions;
    private final User mReceiver;
    private final RichCompletion completion;

    public RPCSendP2PSignalMessage(CSMessage cSMessage, SendingOptions sendingOptions, User user, RichCompletion richCompletion) {
        this.mCSMessage = cSMessage;
        this.mSendingOptions = sendingOptions;
        this.mReceiver = user;
        this.completion = richCompletion;
    }

    public void buildHummerRequest(@NonNull Signal.P2PSignalRequest.Builder builder) {
        builder.setFromUid(HMR.getMe().getId()).setToUid(this.mReceiver.getId()).setType(this.mCSMessage.getType()).setContent(ByteString.copyFrom((byte[])this.mCSMessage.getData()));
        if (this.mCSMessage.getAppExtras() != null && this.mCSMessage.getAppExtras().size() > 0) {
            builder.putAllExtensions(this.mCSMessage.getAppExtras());
        }
        String string = this.mSendingOptions.isUnreliable() ? "no" : "yes";
        Signal.SignalMessageOption.Builder builder2 = Signal.SignalMessageOption.newBuilder();
        builder2.setReliable(string);
        builder.setOption(builder2);
    }

    public void handleHummerSuccess(@NonNull Signal.P2PSignalResponse p2PSignalResponse) {
        this.mCSMessage.setServerAcceptedTs(p2PSignalResponse.getTimestamp() / 1000L);
        CompletionUtils.dispatchSuccess((RichCompletion)this.completion);
    }

    public void handleHummerError(@Nullable Signal.P2PSignalResponse p2PSignalResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure((RichCompletion)this.completion, (Error)error);
    }

    public String getHummerFunction() {
        return "P2PSignal";
    }
}

