/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.channel._internals.rpc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.Signal;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;

public class RPCQueryUserState
extends IMRPC<Signal.CheckUserIsOnlineRequest, Signal.CheckUserIsOnlineRequest.Builder, Signal.CheckUserIsOnlineResponse> {
    private final User mUser;
    private final RichCompletionArg<Boolean> completion;

    public RPCQueryUserState(User user, RichCompletionArg<Boolean> richCompletionArg) {
        this.mUser = user;
        this.completion = richCompletionArg;
    }

    public void buildHummerRequest(@NonNull Signal.CheckUserIsOnlineRequest.Builder builder) {
        builder.setUid(this.mUser.getId());
    }

    public void handleHummerSuccess(@NonNull Signal.CheckUserIsOnlineResponse checkUserIsOnlineResponse) {
        CompletionUtils.dispatchSuccess(this.completion, (Object)checkUserIsOnlineResponse.getIsOnline());
    }

    public void handleHummerError(@Nullable Signal.CheckUserIsOnlineResponse checkUserIsOnlineResponse, @NonNull Error error) {
        CompletionUtils.dispatchSuccess(this.completion, (Object)false);
    }

    public String getHummerFunction() {
        return "CheckUserIsOnline";
    }

    public String describeHummerRequest(Signal.CheckUserIsOnlineRequest checkUserIsOnlineRequest) {
        return new StringChain().acceptNullElements().add("user", (Object)this.mUser).toString();
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, (Error)error);
    }
}

