/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.channel._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.protobuf.ByteString;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.Objects;
import com.hummer.im._internals.chatsvc.ChatServiceImpl;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.proto.Signal;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.channel.ChannelService;
import com.hummer.im.channel._internals.rpc.RPCDeleteUserInfo;
import com.hummer.im.channel._internals.rpc.RPCFetchMembers;
import com.hummer.im.channel._internals.rpc.RPCFetchMembersByAttr;
import com.hummer.im.channel._internals.rpc.RPCJoinChannel;
import com.hummer.im.channel._internals.rpc.RPCLeaveChannel;
import com.hummer.im.channel._internals.rpc.RPCSetUserInfo;
import com.hummer.im.model.Channel;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ChannelServiceImpl
implements ServiceProvider.Service,
ChannelService {
    public static final String TAG = "ChannelServiceImpl";
    private static final long kRejoinConditionGap = 60000L;
    private static final long kReferenceValue = 946656000L;
    private final HashSet<ChannelService.ChannelServiceListener> mChannelServiceListeners = new HashSet();
    private final HashSet<Channel> mJoinedChannelName = new HashSet();
    private Channel.StateChangedListener mChannelStateListener;
    private long mInitialTimeInterval = 0L;

    private void registerChatServiceExtensions() {
        ChatServiceImpl.registerParserExtension((ChatServiceImpl.ParserExtension)new ChatServiceImpl.ParserExtension(){

            public String toString() {
                return ChannelServiceImpl.TAG;
            }

            public Message parseMessage(String string, String string2, byte[] byArray) {
                return null;
            }

            public Message parseMessage(Im.Msg msg, Source source) {
                try {
                    if (msg.getAction() == Im.Action.KNotifyJoinSignalGroup) {
                        ChannelServiceImpl.this.parseJoinGroupNotify(msg.getContent());
                    } else if (msg.getAction() == Im.Action.KNotifyLeaveSignalGroup) {
                        ChannelServiceImpl.this.parseLeaveGroupNotify(msg.getContent());
                    } else if (msg.getAction() == Im.Action.kNotifyUinfoChange) {
                        ChannelServiceImpl.this.parseMemberInfoChangeNotify(msg.getContent());
                    }
                }
                catch (Throwable throwable) {
                    Log.e((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("parse").info("action", (Object)msg.getAction()).info("msg", (Object)msg.getContent()).info("exception", (Object)throwable.getMessage()));
                }
                return null;
            }
        });
    }

    private void parseJoinGroupNotify(ByteString byteString) {
        if (this.isChannelTimeOut()) {
            Log.i((String)TAG, (Object)Trace.once().method("parseJoinGroupNotify").msg((Object)"Ignore the join msg for heartbeat timeout"));
            return;
        }
        Signal.NotifyJoinSignalGroup notifyJoinSignalGroup = (Signal.NotifyJoinSignalGroup)((Signal.NotifyJoinSignalGroup.Builder)Signal.NotifyJoinSignalGroup.newBuilder().mergeFrom(byteString)).build();
        Channel channel = new Channel(notifyJoinSignalGroup.getGroupId());
        if (!this.mJoinedChannelName.contains(channel)) {
            Log.i((String)TAG, (Object)Trace.once().method("Ignore the join msg for heartbeat timeout").info("groupId", (Object)notifyJoinSignalGroup.getGroupId()));
            return;
        }
        this.notifyUserJoined(channel, new User(notifyJoinSignalGroup.getUid()));
    }

    private void parseLeaveGroupNotify(ByteString byteString) {
        if (this.isChannelTimeOut()) {
            Log.i((String)TAG, (Object)Trace.once().method("parseLeaveGroupNotify").msg((Object)"Ignore the join msg for heartbeat timeout"));
            return;
        }
        Signal.NotifyLeaveSignalGroup notifyLeaveSignalGroup = (Signal.NotifyLeaveSignalGroup)((Signal.NotifyLeaveSignalGroup.Builder)Signal.NotifyLeaveSignalGroup.newBuilder().mergeFrom(byteString)).build();
        Channel channel = new Channel(notifyLeaveSignalGroup.getGroupId());
        if (!this.mJoinedChannelName.contains(channel)) {
            Log.i((String)TAG, (Object)Trace.once().method("Ignore the join msg for heartbeat timeout").info("groupId", (Object)notifyLeaveSignalGroup.getGroupId()));
            return;
        }
        this.notifyUserLeaved(channel, new User(notifyLeaveSignalGroup.getUid()));
    }

    private void parseMemberInfoChangeNotify(ByteString byteString) {
        if (this.isChannelTimeOut()) {
            Log.i((String)TAG, (Object)Trace.once().method("parseMemberInfoChangeNotify").msg((Object)"Ignore the join msg for heartbeat timeout"));
            return;
        }
        Signal.NotifyUinfoChange notifyUinfoChange = (Signal.NotifyUinfoChange)((Signal.NotifyUinfoChange.Builder)Signal.NotifyUinfoChange.newBuilder().mergeFrom(byteString)).build();
        Channel channel = new Channel(notifyUinfoChange.getGroupId());
        if (!this.mJoinedChannelName.contains(channel)) {
            Log.i((String)TAG, (Object)Trace.once().method("Ignore the join msg for heartbeat timeout").info("groupId", (Object)notifyUinfoChange.getGroupId()));
            return;
        }
        if (Objects.equals((Object)notifyUinfoChange.getOpType(), (Object)Signal.NotifyUinfoChange.OpType.kOpUpdate)) {
            this.notifyUserInfoUpdate(channel, new User(notifyUinfoChange.getUid()), notifyUinfoChange.getInfosMap());
        } else if (Objects.equals((Object)notifyUinfoChange.getOpType(), (Object)Signal.NotifyUinfoChange.OpType.kOpDel)) {
            this.notifyUserInfoDelete(channel, new User(notifyUinfoChange.getUid()), notifyUinfoChange.getInfosMap().keySet());
        } else if (notifyUinfoChange.getOpType().equals((Object)Signal.NotifyUinfoChange.OpType.kOpAdd)) {
            Log.w((String)TAG, (Object)Trace.once().method("parseMemberInfoChangeNotify").msg("the operator type[%s] is not parse", new Object[]{notifyUinfoChange.getOpType()}));
        } else {
            Log.w((String)TAG, (Object)Trace.once().method("parseMemberInfoChangeNotify").msg("the operator type[%s] is not exist", new Object[]{notifyUinfoChange.getOpType()}));
        }
    }

    private void notifyUserLeaved(final @NonNull Channel channel, final @NonNull User user) {
        DispatchQueue.main.async("ChannelServiceImpl::notifyUserLeaved", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyUserLeaved").info("user", (Object)user.getId()).info("channel", (Object)channel.getName()));
                HashSet hashSet = ChannelServiceImpl.this.mChannelServiceListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mChannelServiceListeners.clone();
                    for (ChannelService.ChannelServiceListener channelServiceListener : hashSet2) {
                        channelServiceListener.onUserLeaved(channel, user);
                    }
                }
            }
        });
    }

    private void notifyUserJoined(final @NonNull Channel channel, final @NonNull User user) {
        DispatchQueue.main.async("ChannelService::notifyUserJoined", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyUserJoined").info("member", (Object)user.getId()).info("channel", (Object)channel.getName()));
                HashSet hashSet = ChannelServiceImpl.this.mChannelServiceListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mChannelServiceListeners.clone();
                    for (ChannelService.ChannelServiceListener channelServiceListener : hashSet2) {
                        channelServiceListener.onUserJoined(channel, user);
                    }
                }
            }
        });
    }

    private void notifyUserInfoUpdate(final @NonNull Channel channel, final @NonNull User user, final @Nullable Map<String, String> map) {
        DispatchQueue.main.async("ChannelService::notifyMemberInfoUpdate", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyMemberInfoUpdate").info("user", (Object)user.getId()).info("channel", (Object)channel.getName()).info("info", (Object)map));
                HashSet hashSet = ChannelServiceImpl.this.mChannelServiceListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mChannelServiceListeners.clone();
                    for (ChannelService.ChannelServiceListener channelServiceListener : hashSet2) {
                        channelServiceListener.onUserInfoSet(channel, user, map);
                    }
                }
            }
        });
    }

    private void notifyUserInfoDelete(final @NonNull Channel channel, final @NonNull User user, final @Nullable Set<String> set) {
        DispatchQueue.main.async("ChannelService::notifyUserInfoDelete", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("notifyUserInfoDelete").info("user", (Object)user.getId()).info("channel", (Object)channel.getName()));
                HashSet hashSet = ChannelServiceImpl.this.mChannelServiceListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)ChannelServiceImpl.this.mChannelServiceListeners.clone();
                    for (ChannelService.ChannelServiceListener channelServiceListener : hashSet2) {
                        channelServiceListener.onUserInfoRemove(channel, user, set);
                    }
                }
            }
        });
    }

    private String getTopic(String string) {
        return String.format(Locale.US, "SignalService/%s", string);
    }

    private static long djbHash(String string) {
        String string2 = Base64.encodeToString((byte[])string.getBytes(), (int)2);
        long l = 5381L;
        for (int i = 0; i < string2.length(); ++i) {
            long l2 = l << 5 & 0xFFFFFFFFL;
            l = (l2 + l & 0xFFFFFFFFL) + (long)string2.charAt(i);
            l &= 0xFFFFFFFFL;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveChannelIfNeed() {
        if (!this.isChannelTimeOut()) {
            Log.i((String)TAG, (Object)"leaveChannelIfNeed return");
            return;
        }
        if (this.mJoinedChannelName.size() > 0) {
            Log.i((String)TAG, (Object)"Leave all channel for offline");
            HashSet<Channel> hashSet = this.mJoinedChannelName;
            synchronized (hashSet) {
                HashSet hashSet2 = (HashSet)this.mJoinedChannelName.clone();
                for (Channel channel : hashSet2) {
                    this.notifyUserLeaved(channel, HMR.getMe());
                    this.leaveChannel(channel, null, null);
                }
            }
        }
    }

    private boolean isChannelTimeOut() {
        long l = System.currentTimeMillis();
        return this.mInitialTimeInterval > 946656000L && l - this.mInitialTimeInterval >= 60000L;
    }

    private void recordInitialTimeIntervalIfNeeded() {
        if (this.mInitialTimeInterval < 946656000L) {
            this.mInitialTimeInterval = System.currentTimeMillis();
        }
    }

    private void resetInitialTimeInterval() {
        this.mInitialTimeInterval = 0L;
    }

    private void prepareChannel() {
        if (this.mChannelStateListener != null) {
            Log.e((String)TAG, (Object)Trace.once().method("prepareChannel").info("mChannelStateListener exception", null));
            return;
        }
        this.mChannelStateListener = new Channel.StateChangedListener(){

            public void onChannelConnected() {
                HMRContext.work.async("ChannelService::onChannelConnected", new Runnable(){

                    @Override
                    public void run() {
                        Log.w((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("onChannelConnected"));
                        ChannelServiceImpl.this.leaveChannelIfNeed();
                        ChannelServiceImpl.this.resetInitialTimeInterval();
                    }
                });
            }

            public void onChannelDisconnected() {
                HMRContext.work.async("ChannelService::onChannelDisconnected", new Runnable(){

                    @Override
                    public void run() {
                        Log.w((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("onChannelDisconnected"));
                        ChannelServiceImpl.this.recordInitialTimeIntervalIfNeeded();
                    }
                });
            }
        };
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).addStateListener(this.mChannelStateListener);
    }

    private void teardownChannel() {
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).removeStateListener(this.mChannelStateListener);
        this.mChannelStateListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ChannelService.ChannelServiceListener channelServiceListener) {
        HashSet<ChannelService.ChannelServiceListener> hashSet = this.mChannelServiceListeners;
        synchronized (hashSet) {
            this.mChannelServiceListeners.add(channelServiceListener);
        }
        Log.i((String)TAG, (Object)Trace.once().method("addChannelServiceListener").info("name", (Object)channelServiceListener.getClass().getSimpleName()).info("size", (Object)this.mChannelServiceListeners.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ChannelService.ChannelServiceListener channelServiceListener) {
        HashSet<ChannelService.ChannelServiceListener> hashSet = this.mChannelServiceListeners;
        synchronized (hashSet) {
            this.mChannelServiceListeners.remove(channelServiceListener);
        }
        Log.i((String)TAG, (Object)Trace.once().method("removeChannelServiceListener").info("name", (Object)channelServiceListener.getClass().getSimpleName()).info("size", (Object)this.mChannelServiceListeners.size()));
    }

    @Override
    public void joinChannel(final @NonNull Channel channel, @Nullable Map<String, String> map, final @Nullable HMR.Completion completion) {
        Log.i((String)TAG, (Object)Trace.once().method("joinChannel").info("channel", (Object)channel));
        RichCompletion richCompletion = new RichCompletion(completion, "ChannelService::joinChannel");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCJoinChannel(channel.getName(), map, new RichCompletion(new HMR.Completion(){

            public void onSuccess() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("joinChannel Done").info("channel", (Object)channel.getName()));
                HMRContext.work.async("", new Runnable(){

                    @Override
                    public void run() {
                        String string = ChannelServiceImpl.this.getTopic(channel.getName());
                        ((MQService)HMR.getService(MQService.class)).addSource((MQService.Source)new Source((Source.Mode)new Source.Shared(ChannelServiceImpl.djbHash(string), string, MQService.FetchStrategy.IgnoreBefore)));
                        ChannelServiceImpl.this.mJoinedChannelName.add(channel);
                    }
                });
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            public void onFailed(Error error) {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("joinChannel fail").info("channel", (Object)channel));
                if (completion != null) {
                    completion.onFailed(error);
                }
            }
        }, "")));
    }

    @Override
    public void leaveChannel(final @NonNull Channel channel, @Nullable Map<String, String> map, final @Nullable HMR.Completion completion) {
        Log.i((String)TAG, (Object)Trace.once().method("leaveChannel").info("channel", (Object)channel));
        RichCompletion richCompletion = new RichCompletion(completion, "ChannelService::leaveChannel");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCLeaveChannel(channel.getName(), map, new RichCompletion(new HMR.Completion(){

            public void onSuccess() {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("leaveChannel Done").info("channel", (Object)channel.getName()));
                HMRContext.work.async("", new Runnable(){

                    @Override
                    public void run() {
                        String string = ChannelServiceImpl.this.getTopic(channel.getName());
                        ((MQService)HMR.getService(MQService.class)).removeSource((MQService.Source)new Source((Source.Mode)new Source.Shared(ChannelServiceImpl.djbHash(string), string)));
                        ChannelServiceImpl.this.mJoinedChannelName.remove(channel.getName());
                    }
                });
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            public void onFailed(Error error) {
                Log.i((String)ChannelServiceImpl.TAG, (Object)Trace.once().method("leaveChannel fail").info("channel", (Object)channel.getName()));
                if (completion != null) {
                    completion.onFailed(error);
                }
            }
        }, "")));
    }

    @Override
    public void fetchMembers(@NonNull Channel channel, @Nullable HMR.CompletionArg<List<User>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChannelService::fetchMembers");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("fetchMembers").info("channel", (Object)channel));
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCFetchMembers(channel.getName(), (RichCompletionArg<List<User>>)richCompletionArg));
    }

    @Override
    public void fetchMembers(@NonNull Channel channel, @NonNull String string, @NonNull String string2, @Nullable HMR.CompletionArg<List<User>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChannelService::fetchMembersByAttr");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("fetchMembersByAttr").info("channel", (Object)channel).info("key", (Object)string).info("value", (Object)string2));
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCFetchMembersByAttr(channel.getName(), string, string2, (RichCompletionArg<List<User>>)richCompletionArg));
    }

    @Override
    public void setUserInfo(@NonNull Channel channel, @NonNull Map<String, String> map, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChannelService::setUserInfo");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("setUserInfo").info("channel", (Object)channel).info("infoMap", map));
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCSetUserInfo(channel.getName(), map, richCompletion));
    }

    @Override
    public void removeUserInfoByKeys(@NonNull Channel channel, @NonNull Set<String> set, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChannelService::removeUserInfoByKeys");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("deleteUserAttrByKeys").info("channel", (Object)channel).info("keys", set));
        ((com.hummer.im.service.Channel)HMR.getService(com.hummer.im.service.Channel.class)).run((Channel.RPC)new RPCDeleteUserInfo(channel.getName(), set, richCompletion));
    }

    public Class[] staticDependencies() {
        return new Class[0];
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{com.hummer.im.service.Channel.class};
    }

    public Class[] plantingDynamicDependencies() {
        return new Class[0];
    }

    public void initService() {
        this.registerChatServiceExtensions();
        ((MQService)HMR.getService(MQService.class)).addSource((MQService.Source)new Source((Source.Mode)new Source.Private("SignalService/P2P", MQService.FetchStrategy.IgnoreBefore, 300000L)));
    }

    public void openService(@NonNull RichCompletion richCompletion) {
        this.prepareChannel();
        CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
    }

    public void closeService() {
        this.teardownChannel();
        this.resetInitialTimeInterval();
    }
}

