package com.hummer.im.channel._internals.rpc;


import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.channel._internals.proto.ChannelYYProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;

import java.util.Map;

public class RPCSetUserInfo extends ChatRoomRPC<ChannelYYProto.PCS_ChannelServiceSetUserInfoRes> {

    public RPCSetUserInfo(String channelId, Map<String, String> infoMap, RichCompletion completion) {
        this.channelId = channelId;
        this.infoMap = infoMap;
        this.completion = completion;
    }

    @Override
    public String getServiceName() {
        return "channel_service_auther";
    }

    @Override
    public String getFunctionName() {
        return "SetUserInfo";
    }

    @Override
    public Marshallable requestObj() {
        ChannelYYProto.PCS_ChannelServiceSetUserInfoReq req = new ChannelYYProto.PCS_ChannelServiceSetUserInfoReq();

        req.appid = Uint32.toUInt(HMRContext.appId);
        req.channelId = this.channelId;
        req.uid = Uint64.toUInt(HMR.getMe().getId());
        if (infoMap != null) {
            req.extendProps = this.infoMap;
        }

        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChannelYYProto.PCS_ChannelServiceSetUserInfoRes res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private String channelId;
    private Map<String, String> infoMap;
    private RichCompletion completion;
}
