package com.hummer.im.channel._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.channel._internals.proto.ChannelYYProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;

public class RPCSendBroadcast extends ChatRoomRPC<ChannelYYProto.PCS_ChannelServiceSendBroadcastRes> {

    public RPCSendBroadcast(String channelId,
                            String type,
                            String content,
                            boolean reliable,
                            RichCompletion completion) {
        this.channelId = channelId;
        this.type = type;
        this.content = content;
        this.reliable = reliable;
        this.completion = completion;
    }

    @Override
    public String getServiceName() {
        return "channel_service_auther";
    }

    @Override
    public String getFunctionName() {
        return "SendBroadcast";
    }

    @Override
    public Marshallable requestObj() {
        ChannelYYProto.PCS_ChannelServiceSendBroadcastReq req
                = new ChannelYYProto.PCS_ChannelServiceSendBroadcastReq();

        req.appid = Uint32.toUInt(HMRContext.appId);
        req.type = type;
        req.channelId = this.channelId;
        req.uid = Uint64.toUInt(HMR.getMe().getId());
        req.content = this.content;
        req.reliable = this.reliable;

        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChannelYYProto.PCS_ChannelServiceSendBroadcastRes res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private String channelId;
    private String type;
    private String content;
    private boolean reliable;
    private RichCompletion completion;
}
