package com.hummer.im.channel._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.channel._internals.proto.ChannelYYProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;

import java.util.Map;

public final class RPCLeaveChannel extends
        ChatRoomRPC<ChannelYYProto.PCS_ChannelServiceLeaveRes> {

    public RPCLeaveChannel(String channelId,
                           Map<String, String> appExtras,
                           RichCompletion completion) {
        this.channelId = channelId;
        this.appExtras = appExtras;
        this.completion = completion;
    }

    @Override
    public String getFunctionName() {
        return "LeaveChannelService";
    }

    @Override
    public String getServiceName() {
        return "channel_service_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChannelYYProto.PCS_ChannelServiceLeaveReq req
                = new ChannelYYProto.PCS_ChannelServiceLeaveReq();

        req.appid = Uint32.toUInt(HMRContext.appId);
        req.channelId = this.channelId;
        req.uid = Uint64.toUInt(HMR.getMe().getId());
        if (appExtras != null) {
            req.extendProps = appExtras;
        }
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChannelYYProto.PCS_ChannelServiceLeaveRes res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleError(@NonNull final Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private String channelId;
    private Map<String, String> appExtras;
    private RichCompletion completion;
}
